
import { MesBaseCplxPageModel, MesBaseCplxPageParams, MesBaseCplxPageResult } from './model/CplxModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/cplx/page',
  List = '/jcsj/cplx/list',
  Info = '/jcsj/cplx/info',
  MesBaseCplx = '/jcsj/cplx',
  
  
  
}

/**
 * @description: 查询MesBaseCplx分页列表
 */
export async function getMesBaseCplxPage(params: MesBaseCplxPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseCplxPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesBaseCplx信息
 */
export async function getMesBaseCplx(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseCplxPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesBaseCplx
 */
export async function addMesBaseCplx(mesBaseCplx: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesBaseCplx,
      params: mesBaseCplx,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesBaseCplx
 */
export async function updateMesBaseCplx(mesBaseCplx: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesBaseCplx,
      params: mesBaseCplx,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesBaseCplx（批量删除）
 */
export async function deleteMesBaseCplx(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesBaseCplx,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




