
import { MesWarehouseArrivedPageModel, MesWarehouseArrivedPageParams, MesWarehouseArrivedPageResult } from './model/CgdhModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/cgdh/page',
  List = '/ckgl/cgdh/list',
  Info = '/ckgl/cgdh/info',
  MesWarehouseArrived = '/ckgl/cgdh',
  
  
  
}

/**
 * @description: 查询MesWarehouseArrived分页列表
 */
export async function getMesWarehouseArrivedPage(params: MesWarehouseArrivedPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseArrivedPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseArrived信息
 */
export async function getMesWarehouseArrived(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseArrivedPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseArrived
 */
export async function addMesWarehouseArrived(mesWarehouseArrived: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseArrived,
      params: mesWarehouseArrived,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseArrived
 */
export async function updateMesWarehouseArrived(mesWarehouseArrived: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseArrived,
      params: mesWarehouseArrived,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseArrived（批量删除）
 */
export async function deleteMesWarehouseArrived(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseArrived,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




