import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'typeCode',
    label: '设备类型代码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'typeName',
    label: '设备类型名称',
    component: 'Input',
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'typeCode',
    title: '设备类型代码',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'typeName',
    title: '设备类型名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '状态',
    componentType: 'switch',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps: FormProps = {
  // labelCol: { offset: 0, span: 3 },
  labelWidth: 120,
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '8a740edb987e4e85bfd659202ded030d',
      field: 'typeCode',
      label: '设备类型代码',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 100,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入设备类型代码',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '4401e50862624dbfb5afd25680bf8cdd',
      field: 'typeName',
      label: '设备类型名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 200,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入设备类型名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'ea59cb41f8704e31884b30a31041a613',
      field: 'sort',
      label: '排序',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 24 },
      defaultValue: 0,
      componentProps: {
        controls: true,
        //max: 100,
        defaultValue: 0,
        rules: [],
        subTotal: false,
        showLabel: true,
        required: false,
        min: 0,
        width: '100%',
        step: 1,
        disabled: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '4b2554efe48247a9a94fdb457c171cf4',
      field: 'state',
      label: '状态',
      type: 'switch',
      component: 'Switch',
      colProps: { span: 24 },
      defaultValue: 1,
      componentProps: {
        defaultValue: 1,
        unCheckedChildren: '',
        unCheckedColor: '#bbbdbf',
        checkedChildren: '',
        showLabel: true,
        checkedColor: '#5e95ff',
        disabled: false,
        events: {},
        span: '',
        style: {},
      },
    },
    {
      key: 'aae51d9b45a64d4bb1af49dda0db0dc6',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 255,
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入备注',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '953d757eed99422db66325f195076fae',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      ifShow: false,
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '88217b6a0f6141b08ab7bbe5d6f9ca03',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      ifShow: false,
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 2,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
