
import { MesProductOutputPageModel, MesProductOutputPageParams, MesProductOutputPageResult } from './model/CcmxModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/scgl/ccmx/page',
  List = '/scgl/ccmx/list',
  Info = '/scgl/ccmx/info',
  MesProductOutput = '/scgl/ccmx',
  
  
  
}

/**
 * @description: 查询MesProductOutput分页列表
 */
export async function getMesProductOutputPage(params: MesProductOutputPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProductOutputPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProductOutput信息
 */
export async function getMesProductOutput(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProductOutputPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProductOutput
 */
export async function addMesProductOutput(mesProductOutput: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesProductOutput,
      params: mesProductOutput,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProductOutput
 */
export async function updateMesProductOutput(mesProductOutput: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesProductOutput,
      params: mesProductOutput,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProductOutput（批量删除）
 */
export async function deleteMesProductOutput(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProductOutput,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




