
import { MesEquipmentPageModel, MesEquipmentPageParams, MesEquipmentPageResult } from './model/ShebeiglModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/sbgl/shebeigl/page',
  List = '/sbgl/shebeigl/list',
  Info = '/sbgl/shebeigl/info',
  MesEquipment = '/sbgl/shebeigl',
  
  
  
}

/**
 * @description: 查询MesEquipment分页列表
 */
export async function getMesEquipmentPage(params: MesEquipmentPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesEquipmentPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesEquipment信息
 */
export async function getMesEquipment(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesEquipmentPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesEquipment
 */
export async function addMesEquipment(mesEquipment: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesEquipment,
      params: mesEquipment,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesEquipment
 */
export async function updateMesEquipment(mesEquipment: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesEquipment,
      params: mesEquipment,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesEquipment（批量删除）
 */
export async function deleteMesEquipment(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesEquipment,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




