
import { MesEquipmentCheckPlanPageModel, MesEquipmentCheckPlanPageParams, MesEquipmentCheckPlanPageResult } from './model/SbdjfaModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/sbgl/sbdjfa/page',
  List = '/sbgl/sbdjfa/list',
  Info = '/sbgl/sbdjfa/info',
  MesEquipmentCheckPlan = '/sbgl/sbdjfa',
  
  
  
}

/**
 * @description: 查询MesEquipmentCheckPlan分页列表
 */
export async function getMesEquipmentCheckPlanPage(params: MesEquipmentCheckPlanPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesEquipmentCheckPlanPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesEquipmentCheckPlan信息
 */
export async function getMesEquipmentCheckPlan(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesEquipmentCheckPlanPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesEquipmentCheckPlan
 */
export async function addMesEquipmentCheckPlan(mesEquipmentCheckPlan: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesEquipmentCheckPlan,
      params: mesEquipmentCheckPlan,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesEquipmentCheckPlan
 */
export async function updateMesEquipmentCheckPlan(mesEquipmentCheckPlan: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesEquipmentCheckPlan,
      params: mesEquipmentCheckPlan,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesEquipmentCheckPlan（批量删除）
 */
export async function deleteMesEquipmentCheckPlan(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesEquipmentCheckPlan,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




