import {
  MesProScheduleModel,
  MesProSchedulePageParams,
  MesProSchedulePageResult,
} from './model/ProScheduleModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/proschedule/page',
  List = '/mes/proschedule/list',
  Info = '/mes/proschedule/info',
  MesProSchedule = '/mes/proschedule',
  SalesOrder = '/magic-api/mes/getSaleOrderListSches',
}

export async function getSalesOrderInfo(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProSchedulePageResult>(
    {
      url: Api.SalesOrder,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询MesProSchedule分页列表
 */
export async function getMesProSchedulePage(
  params: MesProSchedulePageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesProSchedulePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProSchedule信息
 */
export async function getMesProSchedule(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProScheduleModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProSchedule
 */
export async function addMesProSchedule(
  mesProSchedule: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesProSchedule,
      params: mesProSchedule,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProSchedule
 */
export async function updateMesProSchedule(
  mesProSchedule: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesProSchedule,
      params: mesProSchedule,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProSchedule（批量删除）
 */
export async function deleteMesProSchedule(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProSchedule,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function publishMesProSchedule(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: '/mes/proschedule/publish/' + id,
    },
    {
      errorMessageMode: mode,
    },
  );
}
