import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
import { FormTemplatePageModel, FormTemplateParamsModel, PageListSearchModel } from './model';

enum Api {
  List = '/system/form-design-template/page',
  FormTemplate = '/system/form-design-template',
  Info = '/system/form-design-template/info',
}

/**
 * @description: 查询表单模板列表（分页）
 */
export async function getFormTemplateList(
  params?: PageListSearchModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<FormTemplatePageModel>(
    {
      url: Api.List,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增表单模板
 */
export async function addFormTemplate(
  data: FormTemplateParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<number>(
    {
      url: Api.FormTemplate,
      data,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 编辑表单模板
 */
export async function editFormTemplate(
  data: FormTemplateParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<number>(
    {
      url: Api.FormTemplate,
      data,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除表单模板（批量删除）
 */
export async function deleteFormTemplate(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.FormTemplate,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询表单模板详情
 */
export async function getFormTemplateInfo(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<FormTemplateParamsModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}
