
import { MesWarehouseInventoryPageModel, MesWarehouseInventoryPageParams, MesWarehouseInventoryPageResult } from './model/KcpdModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/kcpd/page',
  List = '/ckgl/kcpd/list',
  Info = '/ckgl/kcpd/info',
  MesWarehouseInventory = '/ckgl/kcpd',
  
  
  Export = '/ckgl/kcpd/export',
  
}

/**
 * @description: 查询MesWarehouseInventory分页列表
 */
export async function getMesWarehouseInventoryPage(params: MesWarehouseInventoryPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseInventoryPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseInventory信息
 */
export async function getMesWarehouseInventory(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseInventoryPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseInventory
 */
export async function addMesWarehouseInventory(mesWarehouseInventory: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseInventory,
      params: mesWarehouseInventory,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseInventory
 */
export async function updateMesWarehouseInventory(mesWarehouseInventory: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseInventory,
      params: mesWarehouseInventory,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseInventory（批量删除）
 */
export async function deleteMesWarehouseInventory(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseInventory,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}



/**
 * @description: 导出MesWarehouseInventory
 */
export async function exportMesWarehouseInventory(
  params?: object, 
  mode: ErrorMessageMode = 'modal'
) {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
  

