
import {
  http
} from '@/common/request/index.js'; // 局部引入

const api = {
  Page : '/ckgl/pcgl/page',
  List : '/ckgl/pcgl/list',
  Info : '/ckgl/pcgl/info',
  MesWarehouseBatch : '/ckgl/pcgl'
}

/**
 * 根据参数  查询MesWarehouseBatch分页列表
 * @param {Object} params - 查询参数  
 */
export const getMesWarehouseBatchPage = (params) => {
  return http.get(api.Page, {
    params
  })
}

  
/**
 * 根据参数 查询MesWarehouseBatch列表
 * @param {Object} params - 查询参数  
 */
export const getMesWarehouseBatchList = (params) => {
  return http.get(api.List, {
    params
  })
}

/**
 * 获取MesWarehouseBatch信息
 * @param {Object} params - id  
 */
export const getMesWarehouseBatch = (id) => {
  return http.get(api.Info, {
    params: { id },
  })
}

/**
 * 新增MesWarehouseBatch
 * @param {Object} params - 表单数据  
 */
export const addMesWarehouseBatch = (formData) => {
  return http.post(api.MesWarehouseBatch, formData)
}

/**
 * 修改MesWarehouseBatch
 * @param {Object} params - 表单数据  
 */
export const updateMesWarehouseBatch = (formData) => {
  return http.put(api.MesWarehouseBatch, formData)
}

/**
 * 删除MesWarehouseBatch（批量删除）
 * @param {Object} params - 表单数据  
 */
export const deleteMesWarehouseBatch = (ids) => {
  return http.delete(api.MesWarehouseBatch, ids)
}
