import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'zuJianBianMa6514',
    label: '组件编码 ',
    component: 'Input',
  },
  {
    field: 'zuJianMingChen2489',
    label: '组件名称',
    component: 'Input',
  },
  {
    field: 'shiFuShangJia3901',
    label: '状态',
    component: 'Select',
    componentProps: {
      getPopupContainer: () => document.body,
      options: [
        {
          label: '上架',
          value: 1,
        },
        {
          label: '下架',
          value: 0,
        },
      ],
    },
  },

  {
    field: 'zuJianFenLei1675',
    label: '组件分类',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1881874836500508673' },
      labelField: 'name',
      valueField: 'value',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'zuJianLeiBie9003',
    label: '编译类别',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { key: 1, label: 'html', value: 'html' },
        { key: 2, label: 'vue', value: 'vue' },
        { key: 3, label: '远程vue组件', value: '远程vue组件' },
        { key: 4, label: '远程html组件', value: '远程html组件' },
      ],
      labelField: 'label',
      valueField: 'value',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'zuJianBianMa6514',
    title: '组件编码 ',
    componentType: 'input',

    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'zuJianMingChen2489',
    title: '组件名称',
    componentType: 'input',

    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'zuJianFenLei1675',
    title: '组件分类',
    componentType: 'select',

    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'zuJianLeiBie9003',
    title: '编译类别',
    componentType: 'select',

    customRender: ({ record }) => {
      const staticOptions = [
        { key: 1, label: 'html', value: 'html' },
        { key: 2, label: 'vue', value: 'vue' },
        { key: 3, label: '远程vue组件', value: '远程vue组件' },
        { key: 4, label: '远程html组件', value: '远程html组件' },
      ];

      return staticOptions.filter((x) => x.value === record.zuJianLeiBie9003)[0]?.label;
    },

    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'shiFuShangJia3901',
    title: '状态',
    componentType: 'switch',

    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'vertical',
  size: 'default',
  schemas: [
    {
      key: 'dc096f7308a74c2eb3293f0ac60215c6',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 12,
          list: [
            {
              key: '2c30c07efdae4cb387a8ccd3d24a7410',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 12,
                  list: [
                    {
                      key: 'f09a77b2db3c43b29710b2e87789b4a4',
                      field: 'zuJianBianMa6514',
                      label: '组件编码',
                      type: 'input',
                      component: 'Input',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        placeholder: '请输入组件编码',
                        prefix: '',
                        suffix: '',
                        addonBefore: '',
                        addonAfter: '',
                        disabled: false,
                        allowClear: false,
                        showLabel: true,
                        required: true,
                        rules: [],
                        events: {},
                        listStyle: '',
                        isSave: false,
                        isShow: true,
                        scan: false,
                        style: { width: '100%' },
                      },
                    },
                    {
                      key: '82159e32f3704565b0c965301dd54ec6',
                      field: 'zuJianFenLei1675',
                      label: '组件分类',
                      type: 'select',
                      component: 'DicSelect',
                      colProps: { span: 24 },
                      componentProps: {
                        width: '100%',
                        span: 7,
                        placeholder: '请选择组件分类',
                        showLabel: true,
                        showSearch: false,
                        isShowAdd: true,
                        isMultiple: false,
                        clearable: false,
                        disabled: false,
                        staticOptions: [
                          { key: 1, label: 'Option 1', value: 'Option 1' },
                          { key: 2, label: 'Option 2', value: 'Option 2' },
                          { key: 3, label: 'Option 3', value: 'Option 3' },
                        ],
                        datasourceType: 'dic',
                        params: { itemId: '1881874836500508673' },
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: true,
                        rules: [],
                        events: {},
                        isShow: true,
                        itemId: '1881874836500508673',
                        style: { width: '100%' },
                      },
                    },
                    {
                      key: 'd2cb91d9b17c41898e0c972173a02b9a',
                      field: 'zuJianLeiBie9003',
                      label: '编译类别',
                      type: 'select',
                      component: 'XjrSelect',
                      colProps: { span: 24 },
                      componentProps: {
                        width: '100%',
                        span: 7,
                        placeholder: '请选择编译类别',
                        showLabel: true,
                        showSearch: false,
                        isMultiple: false,
                        clearable: false,
                        disabled: false,
                        staticOptions: [
                          { key: 1, label: 'html', value: 'html' },
                          { key: 2, label: 'vue', value: 'vue' },
                          { key: 3, label: '远程vue组件', value: '远程vue组件' },
                          { key: 4, label: '远程html组件', value: '远程html组件' },
                        ],
                        defaultSelect: 'html',
                        datasourceType: 'staticData',
                        labelField: 'label',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: true,
                        rules: [],
                        events: {
                          change:
                            "const value = formModel.zuJianLeiBie9003;\n  console.log(value,'zuJianLeiBie9003')\nif(value.includes('远程')){   \n\nformActionType.changeCompShow(schema,true,['zuJianDiZhi8745'])\nformActionType.changeCompShow(schema,false,['bianXieQu9373']) \n}else{  formActionType.changeCompShow(schema,false,['zuJianDiZhi8745'])\nformActionType.changeCompShow(schema,true,['bianXieQu9373']) \n}",
                        },
                        isShow: true,
                        style: { width: '100%' },
                      },
                    },
                  ],
                },
                {
                  span: 12,
                  list: [
                    {
                      key: '4900ce88126a479b8b610cd3a7379643',
                      field: 'zuJianMingChen2489',
                      label: '组件名称',
                      type: 'input',
                      component: 'Input',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        placeholder: '请输入组件名称',
                        prefix: '',
                        suffix: '',
                        addonBefore: '',
                        addonAfter: '',
                        disabled: false,
                        allowClear: false,
                        showLabel: true,
                        required: true,
                        rules: [],
                        events: {},
                        listStyle: '',
                        isSave: false,
                        isShow: true,
                        scan: false,
                        style: { width: '100%' },
                      },
                    },
                    {
                      key: '52f6be2aa0e5491da6bef1f22fde711a',
                      field: 'shiFuShangJia3901',
                      label: '是否上架',
                      type: 'switch',
                      component: 'Switch',
                      colProps: { span: 24 },
                      defaultValue: 1,
                      componentProps: {
                        span: 7,
                        defaultValue: 1,
                        checkedChildren: '',
                        unCheckedChildren: '',
                        checkedColor: '#1C8DFF',
                        unCheckedColor: '#bbbdbf',
                        showLabel: true,
                        disabled: false,
                        events: {},
                        isShow: true,
                        style: {},
                      },
                    },
                    {
                      key: '62f6be2aa0e5491da6bef1f22fde711b',
                      field: 'tubiao',
                      label: '图标',
                      type: 'iconPicker',
                      component: 'IconPicker',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        span: 7,
                        defaultValue: '',
                        showLabel: true,
                        disabled: false,
                        events: {},
                        isShow: true,
                        style: {},
                        mode: 'iconify',
                      },
                    },
                  ],
                },
                {
                  span: 24,
                  list: [
                    {
                      key: 'b0128e3aa7214a9a85a5f73cf7d73bee',
                      field: 'beiZhu5563',
                      label: '备注',
                      type: 'textarea',
                      component: 'InputTextArea',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        placeholder: '请输入备注',
                        rows: 4,
                        autoSize: false,
                        showCount: false,
                        disabled: false,
                        showLabel: true,
                        allowClear: false,
                        required: false,
                        isShow: true,
                        rules: [],
                        events: {},
                        style: { width: '100%' },
                      },
                    },
                    {
                      key: 'f3eab9b56e584c20972824876e3bef6f',
                      field: '',
                      label: '',
                      type: 'customScript',
                      component: 'CustomScript',
                      colProps: { span: 24 },
                      componentProps: {
                        disabled: false,
                        isShow: true,
                        events: {},
                        showTitle: false,
                      },
                    },
                  ],
                },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                span: 7,
              },
            },
          ],
        },
        {
          span: 12,
          list: [
            {
              key: '881c050e96b44622b11a7075f571500f',
              field: 'bianXieQu9373',
              label: '编写区',
              type: 'codeEditor',
              component: 'CustomCodeEditor',
              colProps: { span: 24 },
              componentProps: {
                language: 'js',
                readonly: true,
                disabled: false,
                isShow: true,
                events: {},
                height: '400px',
              },
            },
            {
              key: 'be1c5c4da47f4772b3eff411bf7d3eb5',
              field: 'zuJianDiZhi8745',
              label: '组件地址',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入组件地址',
                maxlength: null,
                rows: 4,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: false,
                rules: [],
                events: {},
                isPreviewComp: true,
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 0,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

//左侧树结构配置
export const treeConfig = {
  id: '',
  isMultiple: false,
  name: '',
  type: 1,
  configTip: '',
  config: [],
};
