import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'bh',
    label: '工单编码',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'rwbh',
    label: '任务编号',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'bh',
    title: '工单编码',
    componentType: 'auto-code',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'jhbh',
    title: '计划编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'rwbh',
    title: '任务编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'cpid',
    title: '产品名称',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'hjzt',
    title: '合金标准',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'zch',
    title: '铸次号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'jhksrq',
    title: '计划开始时间',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'jhjsrq',
    title: '计划结束时间',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'zt',
    title: '状态',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'f1c029ad704b4054b1e91d6a2f423b03',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: 'eb63605a152f43fb8fc9097207768b4e',
              field: 'bh',
              label: '工单编码',
              type: 'auto-code',
              component: 'AutoCodeRule',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                showLabel: true,
                autoCodeRule: 'GDBH',
                required: false,
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '44642f34e3ef4aaba849bcb20904bfe2',
              field: 'rwbh',
              label: '任务编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '3dbe2bb97a4d4eaa91a39ec4b3354df9',
              field: 'zl',
              label: '重量/KG',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                step: 0.01,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '4dfaf88607c04e358683b3f4afe7629f',
              field: 'sl',
              label: '数量',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                step: 1,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '543f2a341e2e47c5b7728aa9f64e5b61',
              field: 'zxbz',
              label: '执行标准',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入执行标准',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'edcec677be334cd98a30ffb49501d2e1',
              field: 'cpid',
              label: '产品名称',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/jcxx/getProduct',
                  method: 'GET',
                  apiId: 'copy1767517099244d66500',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select *,id as value,cpmc as label from mes_base_product_info where delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2003761375221407745',
                style: { width: '100%' },
              },
            },
            {
              key: '0b571887e8864132b5287306f1b4c5a8',
              field: 'cplx',
              label: '产品类型',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'dic',
                params: { itemId: '2003761375221407745' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/scjh/getAllProduct',
                  method: 'GET',
                  apiId: 'f4fbb57f2f18425e97918a031c8aa7d8',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,cpmc as label from mes_base_product_info where delete_mark=0';\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2003761375221407745',
                style: { width: '100%' },
              },
            },
            {
              key: '7a484b03fd52412f8698284631cfefc4',
              field: 'jsyq',
              label: '技术要求',
              type: 'upload',
              component: 'Upload',
              colProps: { span: 24 },
              componentProps: {
                api: uploadApi,
                span: 7,
                defaultValue: '',
                accept: '',
                maxNumber: 5,
                maxSize: 5,
                showLabel: true,
                multiple: false,
                disabled: false,
                required: false,
                isShow: true,
                events: {},
                listType: 'text',
                sourceType: 'album,camera',
                tooltipConfig: { visible: false, title: '提示文本' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '059500c0e3644ee69b93b5d4394856ff',
              field: 'jhbh',
              label: '计划编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '54c8380d60eb4c79a1f8e571ed634793',
              field: 'kh',
              label: '客户',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/jcxx/getKhList',
                  method: 'GET',
                  apiId: '7bc8db3faba24b19a997856f6ef0b27e',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from roke_partner where delete_mark = 0 and customer = \'1\'";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '8cba81ae38444cc8aa980e71bc27634f',
              field: 'hjzt',
              label: '合金标准',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/zlgl//zjjcsj/getHjbz',
                  method: 'GET',
                  apiId: '36768924878d48e5ac3b3b24fc25765e',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from mes_alloy_standard where delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '129f257640b143578df327739109cd98',
              field: 'sccj',
              label: '生产车间',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/scrw/getAllChejian',
                  method: 'GET',
                  apiId: '59730efb7b4a4439a013cac04926e00e',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql='select *,id as value,cjmc as label from mes_base_chejian where delete_mark=0'\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'a8a4a06e96964f2a9d7ea44f1ecc0feb',
              field: 'sccx',
              label: '生产产线',
              type: 'associate-select',
              component: 'AssociateSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                disabled: false,
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/scrw/getCxByCjbh',
                  method: 'GET',
                  apiId: 'ecbc0291292c49fca50468561b9770e8',
                  apiParams: [
                    {
                      key: '1',
                      title: 'Query Params',
                      tableInfo: [
                        {
                          name: 'cjid',
                          value:
                            '{"bindField":"sccj","fieldKey":"129f257640b143578df327739109cd98"}',
                          required: true,
                          dataType: 'String',
                          defaultValue: '0',
                          bindType: 'data',
                        },
                      ],
                    },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql='select cx.*,cx.id as value,cx.cxmc as label from mes_base_chanxian cx join mes_base_cj_cx rela on cx.id=rela.cxid where rela.delete_mark=0 and cx.delete_mark=0 and rela.cjid=#{cjid}'\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '9c0fa9d61565467b99cdc62892bda01a',
              field: 'gzzx',
              label: '工作中心',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/jcxx//cjcx/getAllGzzx',
                  method: 'GET',
                  apiId: 'cf582f4ea9814b769291c318c35cbb96',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,gzzxmc as label from mes_base_gzzx where delete_mark=0';\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'e8cd7b3390074ec5b4367e1ceb30d78d',
              field: 'gxId',
              label: '工序',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/jcxx/gxlb',
                  method: 'GET',
                  apiId: '8a735bb14d5f4a709efb65b34691acd3',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select *,id as value,name as label from roke_process where delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2003761375221407745',
                style: { width: '100%' },
              },
            },
            {
              key: 'aa95a59b384344b4bb16cf546092d6cc',
              field: 'sfnbdd',
              label: '是否内部订单',
              type: 'radio',
              component: 'ApiRadioGroup',
              colProps: { span: 24 },
              componentProps: {
                span: 7,
                showLabel: true,
                disabled: false,
                optionType: 'default',
                staticOptions: [
                  { key: 1, label: '是', value: '1' },
                  { key: 2, label: '否', value: '2' },
                ],
                datasourceType: 'staticData',
                labelField: 'label',
                valueField: 'value',
                defaultSelect: 'option 1',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
            {
              key: 'd74b7755d2b3467aba348c7b55a94fc6',
              field: 'zt',
              label: '状态',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: true,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'dic',
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: '/jcxx//cjcx/getAllGzzx',
                  method: 'GET',
                  apiId: 'cf582f4ea9814b769291c318c35cbb96',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,gzzxmc as label from mes_base_gzzx where delete_mark=0';\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                params: { itemId: '2011260635030495233' },
                defaultSelect: '未开始',
                itemId: '2011260635030495233',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'fada4c1222a94076a8e811c6489ce593',
              field: 'zch',
              label: '铸次号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入铸次号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'b2f47b2858a3431eae67fb292aad937c',
              field: 'zzl',
              label: '铸造量',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入铸造量',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'dca82bcd3e7b44dfa96df1bc5a8d3ff3',
              field: 'rch',
              label: '熔次号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入熔次号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'dc5d1cdc42b34094a3d6af5ee787e0df',
              field: 'jhksrq',
              label: '计划开始时间',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择计划开始时间',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
            {
              key: '18a845043f1a44e4952c7255fb352aa5',
              field: 'jhjsrq',
              label: '计划结束时间',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择计划结束时间',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
            {
              key: '32d66a3f683c4cb482f439d0619412fd',
              field: 'bz',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入备注',
                rows: 4,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '5ddb609cd16c4f06a850181c1174b0d5',
      field: '',
      label: '',
      type: 'tab',
      colProps: { span: 24 },
      component: 'Tab',
      children: [
        {
          span: 24,
          name: '报工详情',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: 'f6d19f4efe76492a92b01559e0161b67',
              label: '',
              field: 'mesGongdanReportList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesGongdanReportList',
                columns: [
                  {
                    key: '52c0cefc838d49559f893c5f0df5c415',
                    title: '编号',
                    dataIndex: 'bh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '8b197117182e456184210b4de17e6c55',
                    title: '合金',
                    dataIndex: 'hj',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'ecc71641608a45338b75896b3d74d281',
                    title: '完工数',
                    dataIndex: 'wgs',
                    componentType: 'InputNumber',
                    componentProps: {
                      width: '100%',
                      span: '',
                      min: 0,
                      step: 0.01,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '02a6289d315f4dfba0bd9c2b221a6c13',
                    title: '工时',
                    dataIndex: 'gs',
                    componentType: 'InputNumber',
                    componentProps: {
                      width: '100%',
                      span: '',
                      min: 0,
                      step: 0.01,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '2b194358608446fa8bbfa70277355b0e',
                    title: '报工时间',
                    dataIndex: 'bgsj',
                    componentType: 'DatePicker',
                    defaultValue: '',
                    componentProps: {
                      span: '',
                      defaultValue: '',
                      width: '100%',
                      placeholder: '',
                      format: 'YYYY-MM-DD HH:mm:ss',
                      showLabel: true,
                      allowClear: true,
                      disabled: false,
                      required: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      isGetCurrent: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      searchType: 'time',
                    },
                  },
                  {
                    key: 'd1be2664bb724b73a86b84338206a6cf',
                    title: '报工人',
                    dataIndex: 'bgr',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '18931140853340a59e8ab5315752d452',
                    title: '报工班组',
                    dataIndex: 'bgzz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '6564108f49f548a799a4f0e6d8b209c3',
                    title: '作业人',
                    dataIndex: 'zyr',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'c99c48913605403db427666e6b90fc9b',
                    title: '备注',
                    dataIndex: 'bz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: true,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
        /*{
          span: 24,
          name: '数据采集详情',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '6858fe13441243c790a63bf5b974435b',
              label: '',
              field: 'mesGongdanDataCollectionList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesGongdanDataCollectionList',
                columns: [
                  {
                    key: '89af383317a948508759eadd9d48adb6',
                    title: '采集项',
                    dataIndex: 'cjx',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'b17eaa6f85024c26b22c9551354e3c5a',
                    title: '采集值',
                    dataIndex: 'cjz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '63ab9a80ee1945399e73dd9310e91aa8',
                    title: '标准值',
                    dataIndex: 'bzz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '553e79c992b74ecb91c3bf3ccd2af87c',
                    title: '备注',
                    dataIndex: 'bz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: true,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },*/
        {
          span: 24,
          name: '质检信息',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '24408a8dcca1423789dcdeff031e4d9f',
              label: '',
              field: 'mesGongdanQualityInspectionList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesGongdanQualityInspectionList',
                columns: [
                  {
                    key: '62f5f554a68244f5b721f73d4c68988e',
                    title: '质检单号',
                    dataIndex: 'zjdh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '19ec9fc3d6394fcab8b472d857a4f31b',
                    title: '质检结果',
                    dataIndex: 'zjjg',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'e6d92e00e9da4bb59ca4e664119ae183',
                    title: '质检员',
                    dataIndex: 'jyy',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'c6d641ee7dfc4336ae157553c1a4e4e9',
                    title: '质检信息',
                    dataIndex: 'zjsj',
                    componentType: 'DatePicker',
                    defaultValue: '',
                    componentProps: {
                      span: '',
                      defaultValue: '',
                      width: '100%',
                      placeholder: '',
                      format: 'YYYY-MM-DD HH:mm:ss',
                      showLabel: true,
                      allowClear: true,
                      disabled: false,
                      required: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      isGetCurrent: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      searchType: 'time',
                    },
                  },
                  {
                    key: '3b9215b704c74d9bad707adf6c04f50f',
                    title: '备注',
                    dataIndex: 'bz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: true,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
        {
          span: 0,
          name: '投料信息',
          list: [
            {
              key: '3de87256379c41d18252370cb451630f',
              label: '',
              field: 'mesGongdanMaterialFeedingList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesGongdanMaterialFeedingList',
                columns: [
                  {
                    key: 'd9196faf398347cd958ec21de698e780',
                    title: '物料编号',
                    dataIndex: 'wlbh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'f255a9b82d6646d6ac6750c9fbf87329',
                    title: '物料名称',
                    dataIndex: 'wlmc',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '43490105227045229f2f1816f6ff8474',
                    title: '数量',
                    dataIndex: 'tlsl',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      step: 0.01,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: 'c9f4ec8bb7a944d19f1e6ce4582c3509',
                    title: '投料人',
                    dataIndex: 'tlr',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '57d915aeb50f490cbe2970a29921989b',
                    title: '备注',
                    dataIndex: 'bz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: true,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
        {
          span: 0,
          name: '生产采集信息',
          list: [
            {
              key: 'c9e3e41674b841a285aca529b7ef8a64',
              label: '',
              field: 'mesGongdanScCollectionList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesGongdanScCollectionList',
                columns: [
                  {
                    key: '5e21bdbe50864ceba2f6e4a54f497427',
                    title: '采集项',
                    dataIndex: 'cjx',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'ee243d18029947e19f527e1b38417d3b',
                    title: '采集值',
                    dataIndex: 'cjz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '4d07e4bfe0224ba2ac17464973bc42dc',
                    title: '备注',
                    dataIndex: 'bz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: true,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
      ],
      componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
