import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'cphm',
    label: '车牌号码',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/cheliang/py-list',
        method: 'GET',
        apiId: '81d881afe72d4be3a05677caa75e6342',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          "return db.select('SELECT id, cllx, gbzl, cphm AS `value`, cphm AS label FROM mes_base_cheliang WHERE sfcj = \\'0\\';');",
        outputParams: [
          { name: 'label', tableTitle: '车牌号码', bindField: null, show: true, width: 150 },
          {
            name: 'cllx',
            tableTitle: '',
            bindField: 'cllx',
            show: false,
            width: 150,
            component: '6ef2584234dd425faaaf5c7896181019',
          },
          { name: 'cllx_name', tableTitle: '车辆类型', bindField: null, show: true, width: 150 },
          {
            name: 'gbzl',
            tableTitle: '车辆重量(kg)',
            bindField: 'clzl',
            show: true,
            width: 150,
            component: 'ae99d59a65304fa5a0ea3f4c9a87e524',
          },
        ],
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'cllx',
    label: '车辆类型',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2017066632836796418' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'clzl',
    label: '车辆重量',
    defaultValue: undefined,
    component: 'InputNumber',
    componentProps: {
      style: { width: '100%' },
    },
  },
  {
    field: 'pyr',
    label: '排液人',
    defaultValue: undefined,
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
  },

  {
    field: 'gzxm',
    label: '工作项目',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/cheliang/gzx',
        method: 'GET',
        apiId: 'd31f8fea01274bdf9f1f72464daa59e8',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          "var sql = 'SELECT id AS `value`, gzx AS label FROM mes_base_gongzuoxiang;';\r\nreturn db.select(sql);",
        outputParams: [
          { name: 'label', tableTitle: '工作项', bindField: '', show: true, width: 150 },
        ],
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'gzkssj',
    label: '工作开始时间',
    defaultValue: undefined,
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD HH:mm:ss',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
  },

  {
    field: 'gzjssj',
    label: '工作结束时间',
    defaultValue: undefined,
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD HH:mm:ss',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'cphm',
    title: '车牌号码',
    componentType: 'associate-popup',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'cllx',
    title: '车辆类型',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'clzl',
    title: '车辆重量',
    componentType: 'number',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'pyr',
    title: '排液人',
    componentType: 'user',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'gzxm',
    title: '工作项目',
    componentType: 'associate-popup',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'gzkssj',
    title: '工作开始时间',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'gzjssj',
    title: '工作结束时间',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'b4c421cbd9e54671b9d17967c987c03d',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: 'af19c3eb20d945e093176d60b4f5a0d1',
              field: 'cphm',
              label: '车牌号码',
              type: 'associate-popup',
              component: 'MultiplePopup',
              colProps: { span: 24 },
              componentProps: {
                popupType: 'associate',
                width: '100%',
                span: 7,
                placeholder: '请选择车牌号码',
                showLabel: true,
                disabled: false,
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                pageSize: 10,
                assoTitle: '车牌号码',
                apiConfig: {
                  path: '/cheliang/py-list',
                  method: 'GET',
                  apiId: '81d881afe72d4be3a05677caa75e6342',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "return db.select('SELECT id, cllx, gbzl, cphm AS `value`, cphm AS label FROM mes_base_cheliang WHERE sfcj = \\'0\\';');",
                  outputParams: [
                    { name: 'label', tableTitle: '车牌号码', show: true, width: 150 },
                    {
                      name: 'cllx',
                      tableTitle: '',
                      bindField: 'cllx',
                      show: false,
                      width: 150,
                      component: '6ef2584234dd425faaaf5c7896181019',
                    },
                    { name: 'cllx_name', tableTitle: '车辆类型', show: true, width: 150 },
                    {
                      name: 'gbzl',
                      tableTitle: '车辆重量(kg)',
                      bindField: 'clzl',
                      show: true,
                      width: 150,
                      component: 'ae99d59a65304fa5a0ea3f4c9a87e524',
                    },
                  ],
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '6ef2584234dd425faaaf5c7896181019',
              field: 'cllx',
              label: '车辆类型',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'dic',
                params: { itemId: '2017066632836796418' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2017066632836796418',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'ae99d59a65304fa5a0ea3f4c9a87e524',
              field: 'clzl',
              label: '车辆重量',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                min: 0,
                max: 100,
                step: 1,
                maxlength: null,
                disabled: false,
                showLabel: true,
                controls: true,
                required: true,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                placeholder: '请输入车辆重量',
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '9043491de4e342b881f8012ffa4155ce',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: '115cd0bc43e84138a51cb1e189bfb8e5',
              field: 'pyr',
              label: '排液人',
              type: 'user',
              component: 'User',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                width: '100%',
                defaultValue: '',
                placeholder: '请选择人员',
                userType: 0,
                prefix: '',
                suffix: 'ant-design:setting-outlined',
                showLabel: true,
                disabled: false,
                required: true,
                multiple: true,
                isShow: true,
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '5ab8ad30eda84a05a8ac3393c57a82d2',
              field: 'gzxm',
              label: '工作项目',
              type: 'associate-popup',
              component: 'MultiplePopup',
              colProps: { span: 24 },
              componentProps: {
                popupType: 'associate',
                width: '100%',
                span: 7,
                placeholder: '请选择工作项目',
                showLabel: true,
                disabled: false,
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                pageSize: 10,
                assoTitle: '工作项目',
                apiConfig: {
                  path: '/cheliang/gzx',
                  method: 'GET',
                  apiId: 'd31f8fea01274bdf9f1f72464daa59e8',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'SELECT id AS `value`, gzx AS label FROM mes_base_gongzuoxiang;';\r\nreturn db.select(sql);",
                  outputParams: [{ name: 'label', tableTitle: '工作项', show: true, width: 150 }],
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        { span: 8, list: [] },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: 'aed0b91d0fa14b6fb7318d3a71de47a7',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: '309b6c3f707349a89cd97cf1b00ee0b8',
              field: 'gzkssj',
              label: '工作开始时间',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择工作开始时间',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: true,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'a775006aab184860860da4573b2e185a',
              field: 'gzjssj',
              label: '工作结束时间',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择工作结束时间',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: true,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
          ],
        },
        { span: 8, list: [] },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '88c5a499b17d4e5fb4bb67d1b3ae2e8f',
      field: 'bz',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: 7,
        defaultValue: '',
        placeholder: '请输入备注',
        maxlength: 500,
        rows: 4,
        autoSize: false,
        showCount: true,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        isShow: true,
        isShowAi: false,
        rules: [],
        events: {},
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '100%' },
      },
    },
    {
      key: '4f7e001de6dc4c6eaa7c1385ff2d09da',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [{ span: 24, list: [] }],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: 'ed064b5f5ca945feb5ef37dbf6f06eec',
      field: 'yclqzp',
      label: '预处理前照片',
      type: 'upload',
      component: 'Upload',
      colProps: { span: 24 },
      componentProps: {
        api: uploadApi,
        span: '',
        defaultValue: '',
        accept: '',
        maxNumber: 5,
        maxSize: 5,
        showLabel: true,
        multiple: false,
        disabled: false,
        required: false,
        isShow: true,
        events: {},
        listType: 'picture-card',
        sourceType: 'album,camera',
        tooltipConfig: { visible: false, title: '提示文本' },
      },
    },
    {
      key: '1065c11a72cc4d42983939a2b6a9c2bf',
      field: 'yclhzp',
      label: '预处理后照片',
      type: 'upload',
      component: 'Upload',
      colProps: { span: 24 },
      componentProps: {
        api: '#{upload}#',
        span: '',
        defaultValue: '',
        accept: '',
        maxNumber: 5,
        maxSize: 5,
        showLabel: true,
        multiple: false,
        disabled: false,
        required: false,
        isShow: true,
        events: {},
        listType: 'picture-card',
        sourceType: 'album,camera',
        tooltipConfig: { visible: false, title: '提示文本' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
