
import { MesCheliangPybgPageModel, MesCheliangPybgPageParams, MesCheliangPybgPageResult } from './model/PybgModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/chaiche/pybg/page',
  List = '/chaiche/pybg/list',
  Info = '/chaiche/pybg/info',
  MesCheliangPybg = '/chaiche/pybg',
  
  
  
}

/**
 * @description: 查询MesCheliangPybg分页列表
 */
export async function getMesCheliangPybgPage(params: MesCheliangPybgPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesCheliangPybgPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesCheliangPybg信息
 */
export async function getMesCheliangPybg(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesCheliangPybgPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesCheliangPybg
 */
export async function addMesCheliangPybg(mesCheliangPybg: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesCheliangPybg,
      params: mesCheliangPybg,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesCheliangPybg
 */
export async function updateMesCheliangPybg(mesCheliangPybg: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesCheliangPybg,
      params: mesCheliangPybg,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesCheliangPybg（批量删除）
 */
export async function deleteMesCheliangPybg(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesCheliangPybg,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




