
import { MesCheliangBgPageModel, MesCheliangBgPageParams, MesCheliangBgPageResult } from './model/CcbgModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/chaiche/ccbg/page',
  List = '/chaiche/ccbg/list',
  Info = '/chaiche/ccbg/info',
  MesCheliangBg = '/chaiche/ccbg',
  
  
  
}

/**
 * @description: 查询MesCheliangBg分页列表
 */
export async function getMesCheliangBgPage(params: MesCheliangBgPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesCheliangBgPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesCheliangBg信息
 */
export async function getMesCheliangBg(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesCheliangBgPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesCheliangBg
 */
export async function addMesCheliangBg(mesCheliangBg: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesCheliangBg,
      params: mesCheliangBg,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesCheliangBg
 */
export async function updateMesCheliangBg(mesCheliangBg: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesCheliangBg,
      params: mesCheliangBg,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesCheliangBg（批量删除）
 */
export async function deleteMesCheliangBg(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesCheliangBg,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




