import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'code',
    label: '编号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'name',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'managerId',
    label: '班组长',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/bmxx/getEmployeeList',
        method: 'GET',
        apiId: 'copy1765432049337d61208',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select *,id as value,name as label from roke_employee where active = 1 and delete_mark = 0";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'parentId',
    label: '上级班组',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/bmxx/getworkteamList',
        method: 'GET',
        apiId: 'eeb487680f4a46f8b6bb1113a443fff4',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select id as value,name as label from roke_work_team";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'note',
    label: '',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'code',
    title: '编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'name',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'managerId',
    title: '班组长',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
    customRender: ({ record }) => record.managerName || record.managerId,
  },

  {
    resizable: true,
    dataIndex: 'parentId',
    title: '上级班组',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
    customRender: ({ record }) => record.parentName || record.parentId,
  },

  {
    resizable: true,
    dataIndex: 'note',
    title: '',
    componentType: 'textarea',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '6f173f79321c493481f43e540d39e290',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: '74656a9a548a4ebf8eea9833e58c9751',
              field: 'code',
              label: '编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '自动生成',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'aaeb0e29ad9a4b2dba9751da63f4e12f',
              field: 'name',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '56d9862d077c4ccabde4bb773999046d',
              field: 'managerId',
              label: '班组长',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getEmployeeList',
                  method: 'GET',
                  apiId: 'copy1765432049337d61208',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select *,id as value,name as label from roke_employee where active = 1 and delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '1419276800524423333',
                style: { width: '100%' },
              },
            },
            {
              key: '77d198c396e24e4e8a7d37a57e00cb51',
              field: 'parentId',
              label: '上级班组',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getworkteamList',
                  method: 'GET',
                  apiId: 'eeb487680f4a46f8b6bb1113a443fff4',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from roke_work_team";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'fe9d91a4f2344ff68b0848118966e985',
              field: '',
              label: '班组二维码',
              type: 'qrcode',
              component: 'XjrQrcode',
              colProps: { span: 24 },
              defaultValue: ' ',
              componentProps: {
                span: 7,
                defaultValue: ' ',
                showLabel: true,
                isShow: true,
                codeType: 'api',
                apiConfig: {
                  path: 'CodeGeneration/qr-code',
                  method: 'GET',
                  apiId: '8aad311cb2b248b39e9227d4bad94c9b',
                },
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 2,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: 'c88d421d89424ac79a71bd32d889fed7',
      field: 'note',
      label: '',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '此处可以填写备注或描述',
        maxlength: null,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        isShow: true,
        isShowAi: false,
        rules: [],
        events: {},
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '100%' },
      },
    },
    {
      key: '7e364743b4bd4e249ffd3ec3259ead51',
      field: '',
      label: '',
      type: 'tab',
      colProps: { span: 24 },
      component: 'Tab',
      children: [
        {
          span: 24,
          name: '班组成员',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '203371e1507844af97e5b82500bfc0c8',
              label: '',
              field: 'rokeWorkTeamEmployeeRelList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'rokeWorkTeamEmployeeRelList',
                columns: [
                  {
                    key: '41c418f3422e411fba4025e1ba607791',
                    title: '班组id',
                    dataIndex: 'workTeamId',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '1beafaffe43343a0b16f99b251346fea',
                    title: '班组成员',
                    dataIndex: 'danXingWenBen1923',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: true,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '6788a481e9e7433b9c36e8dad4eeccdd',
                    title: '编号',
                    dataIndex: 'danXingWenBen7962',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: true,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '7b9f6f042ea340d09409b007adf681db',
                    title: '工号',
                    dataIndex: 'gongHao4014',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: true,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '9170dea64ef8410597607c96057b7eeb',
                    title: '电话',
                    dataIndex: 'dianHua7940',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: true,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '526f26d97e2e4b1f9800348c295d0d7d',
                    title: '职位',
                    dataIndex: 'zhiWei8331',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: true,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'f95aab6e4e4a46b2ba2e6b679f3521d8',
                    title: '部门',
                    dataIndex: 'danXingWenBen7768',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: true,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '03da44c148cb46c988a63c5d1f9f173e',
                    title: '技能等级',
                    dataIndex: 'jiNenDengJi2532',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: true,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: true,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  { title: '操作', key: 'action', fixed: 'right', width: '50px' },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: false,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: true,
                isShowDelete: true,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
      ],
      componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const formButtons = [
  {
    key: 'confirm',
    code: 'confirm',
    name: '确定',
    style: 'primary',
    event: [],
    isShow: true,
    index: 2,
    type: 1,
    modal: null,
  },
  {
    key: 'cancel',
    code: 'cancel',
    name: '取消',
    style: 'default',
    event: [],
    isShow: true,
    index: 1,
    type: 1,
    modal: null,
  },
  {
    key: 'reset',
    code: 'reset',
    name: '重置',
    style: 'default',
    event: [],
    isShow: true,
    index: 0,
    type: 1,
    modal: null,
  },
];
