import { OperationType } from '/@/enums/workflowEnum';

export interface RuleProcessListModel {
  id?: string; // 主键
  itemId: string; //分类
  code: string;
  jsonContent: string;
  name: string;
  remark: string;
  processParamConfigs?: Array<RuleProcessParamItem>;
  elValue?: string;
}
export interface RuleProcessParamItem {
  id: number | string;
  name: string;
  type: OperationType;
  value: string;
  apiConfig: {
    id: string;
    name: string;
    method: string;
    requestParamsConfigs: Array<InputParamItem>; //Query Params 输入参数
    requestHeaderConfigs: Array<InputParamItem>; //Header 输入参数
    requestBodyConfigs: Array<InputParamItem>; //Body 输入参数
  };
}

export interface InputParamItem {
  name: string; //API入参名称
  dataType: string; //API入参类型
  assignmentType: string; //赋值类型
  value: string; //值
  config: string; //赋值配置
}
// 赋值类型
export enum AssignmentTypeToRuleType {
  DEFAULT = 0, //默认值
  VALUE, //值
  FORM, //表单数据 组件数据
  // 节点审批结果
  // 流程参数
  // 发起人信息
  // 流程数据
}
