import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesWarehouseIn分页参数 模型
 */
export interface MesWarehouseInPageParams extends BasicPageParams {
  djh: string;

  ck: string;

  gys: string;

  zdr: string;

  pch: string;

  ywzz: string;
}

/**
 * @description: MesWarehouseIn分页返回值模型
 */
export interface MesWarehouseInPageModel {
  id: string;

  djh: string;

  djrq: string;

  crklx: string;

  ck: string;

  gys: string;

  zdr: string;

  pch: string;

  ywzz: string;

  bz: string;
}

/**
 * @description: MesWarehouseIn表类型
 */
export interface MesWarehouseInModel {
  id: string;

  deleteMark: string;

  djh: string;

  djrq: string;

  crklx: string;

  ck: string;

  gys: string;

  zdr: string;

  fj: string;

  bz: string;

  ywzz: string;

  pch: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  mesWarehouseInInfoList?: MesWarehouseInInfoModel;
}

/**
 * @description: MesWarehouseInInfo表类型
 */
export interface MesWarehouseInInfoModel {
  id: string;

  deleteMark: string;

  rkdid: string;

  lydhid: string;

  wlbm: string;

  wlmc: string;

  ggxh: string;

  dw: string;

  pch: string;

  yssl: string;

  sssl: string;

  xqbm: string;

  sfzp: string;

  sfzj: string;

  hwh: string;

  bz: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;
}

/**
 * @description: MesWarehouseIn分页返回值结构
 */
export type MesWarehouseInPageResult = BasicFetchResult<MesWarehouseInPageModel>;
