import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'bh',
    label: '编码',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'mc',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'bh',
    title: '编码',
    componentType: 'auto-code',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'mc',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'bz',
    title: '备注',
    componentType: 'textarea',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '62acff989624456c91704fd1468040d2',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 12,
          list: [
            {
              key: 'a111bc49789444e690cf3a43f4fb81cb',
              field: 'bh',
              label: '编码',
              type: 'auto-code',
              component: 'AutoCodeRule',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '自动生成编码',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                showLabel: true,
                autoCodeRule: 'yyydxj',
                required: false,
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '41ac858b17cb489ab63ff0d2312a955b',
              field: 'bz',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                maxlength: null,
                rows: 2,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 12,
          list: [
            {
              key: '7b2aac9372974259b0a7a6befc91a122',
              field: 'mc',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入名称',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '881e2a7138c94f9ca4fb15c86cb30468',
      field: '',
      label: '',
      type: 'tab',
      colProps: { span: 24 },
      component: 'Tab',
      children: [
        {
          span: 24,
          name: '巡检项',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '5ae6111d5ce4452ba224a4048dcb276c',
              label: '',
              field: 'mesDyxunjianSchemeItemList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesDyxunjianSchemeItemList',
                columns: [
                  {
                    key: 'a5e36ae1a4c745f4932b74a89c7b577c',
                    title: '名称',
                    dataIndex: 'mc',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'mc',
                    },
                  },
                  {
                    key: '72ad4e480c3f4cbb8276f6778ab85de6',
                    title: '标准值',
                    dataIndex: 'bzz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'bzz',
                    },
                  },
                  {
                    key: '72e73be6b62142ae9101eeb96c79fa4e',
                    title: '数据类型',
                    dataIndex: 'sjlx',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'sjlx',
                    },
                  },
                  {
                    key: '7ae0678a922547c39b5e502db80fca4c',
                    title: '标准上限',
                    dataIndex: 'bzsx',
                    componentType: 'InputNumber',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      min: 0,
                      max: null,
                      step: 1,
                      maxlength: null,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      placeholder: '请输入标准上限',
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'bzsx',
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '66cd648c444e402880cd83df300f07f1',
                    title: '标准下限',
                    dataIndex: 'bzxx',
                    componentType: 'InputNumber',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      min: 0,
                      max: null,
                      step: 1,
                      maxlength: null,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      placeholder: '请输入标准下限',
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'bzxx',
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: 'db9ebbbaee0445c2a3a377722a25bdf9',
                    title: '是否必填',
                    dataIndex: 'bt',
                    componentType: 'Switch',
                    defaultValue: 1,
                    componentProps: {
                      span: '',
                      defaultValue: 1,
                      checkedChildren: '',
                      unCheckedChildren: '',
                      checkedColor: '#1C8DFF',
                      unCheckedColor: '#bbbdbf',
                      showLabel: true,
                      disabled: true,
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'bt',
                    },
                  },
                  {
                    key: '770acd4156fb42e9a6c4be7473d7e54b',
                    title: '备注',
                    dataIndex: 'bz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'e2072cf51b084cebad1211d2898af9a8',
                    title: '巡检项ID',
                    dataIndex: 'xjxid',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'id',
                    },
                  },
                  { title: '操作', key: 'action', fixed: 'right', width: '50px' },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {
                  path: '/jcxx/yyydxjx',
                  method: 'GET',
                  apiId: '7b7eac65a1084438987636af9ca6ce4d',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,mc as label from mes_dyxunjian_item where delete_mark=0';\r\nreturn db.select(sql)",
                  outputParams: [
                    { name: 'mc', tableTitle: '名称' },
                    { name: 'bzz', tableTitle: '标准值' },
                    { tableTitle: '数据类型', name: 'sjlx' },
                    { tableTitle: '标准上限', name: 'bzsx' },
                    { tableTitle: '标准下限', name: 'bzxx' },
                    { tableTitle: '是否必填', name: 'bt' },
                    { name: 'id', tableTitle: 'ID' },
                  ],
                },
                itemId: '',
                dicOptions: [],
                useSelectButton: true,
                buttonName: '选择巡检项',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                backgroundStyle: {
                  isShow: false,
                  bgColor: '#ffffff',
                  bgImgUrl: '',
                  fontColor: '',
                  borderColor: '',
                },
                theadStyle: {
                  isShow: false,
                  fontSize: 14,
                  fontColor: '#000000',
                  bgType: 'color',
                  gradientDegree: '',
                  gradientColors: '',
                  bgImageUrl: '',
                  bgColor: '',
                  bgRepeat: 'no-repeat',
                },
                tbodyStyle: {
                  isShow: false,
                  fontSize: 14,
                  fontColor: '#000000',
                  bgType: 'color',
                  gradientDegree: '',
                  gradientColors: '',
                  bgImageUrl: '',
                  bgColor: '',
                  bgRepeat: 'no-repeat',
                },
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: true,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: true,
                isListView: false,
                viewList: [
                  {
                    key: 'a5e36ae1a4c745f4932b74a89c7b577c',
                    label: '名称',
                    field: 'mc',
                    componentType: 'input',
                    checked: true,
                  },
                  {
                    key: '72ad4e480c3f4cbb8276f6778ab85de6',
                    label: '标准值',
                    field: 'bzz',
                    componentType: 'input',
                    checked: true,
                  },
                  {
                    key: '72e73be6b62142ae9101eeb96c79fa4e',
                    label: '数据类型',
                    field: 'sjlx',
                    componentType: 'input',
                    checked: true,
                  },
                  {
                    key: '7ae0678a922547c39b5e502db80fca4c',
                    label: '标准上限',
                    field: 'bzsx',
                    componentType: 'number',
                    checked: true,
                  },
                  {
                    key: '66cd648c444e402880cd83df300f07f1',
                    label: '标准下限',
                    field: 'bzxx',
                    componentType: 'number',
                    checked: true,
                  },
                  {
                    key: 'db9ebbbaee0445c2a3a377722a25bdf9',
                    label: '是否必填',
                    field: 'bt',
                    componentType: 'switch',
                    checked: true,
                  },
                  {
                    key: '770acd4156fb42e9a6c4be7473d7e54b',
                    label: '备注',
                    field: 'bz',
                    componentType: 'input',
                    checked: true,
                  },
                  {
                    key: 'e2072cf51b084cebad1211d2898af9a8',
                    label: '巡检项ID',
                    field: 'xjxid',
                    componentType: 'input',
                    checked: true,
                  },
                ],
                isShowAdd: false,
                isShowDelete: true,
                hasCheckedCol: true,
                checkedColType: 'checkbox',
                pageSize: 10,
                events: {},
                showPagenation: true,
                widths: [
                  {
                    key: 'a5e36ae1a4c745f4932b74a89c7b577c',
                    name: '名称',
                    bindField: 'mc',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: true,
                  },
                  {
                    key: '72ad4e480c3f4cbb8276f6778ab85de6',
                    name: '标准值',
                    bindField: 'bzz',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: true,
                  },
                  {
                    key: '72e73be6b62142ae9101eeb96c79fa4e',
                    name: '数据类型',
                    bindField: 'sjlx',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: true,
                  },
                  {
                    key: '7ae0678a922547c39b5e502db80fca4c',
                    name: '标准上限',
                    bindField: 'bzsx',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: true,
                  },
                  {
                    key: '66cd648c444e402880cd83df300f07f1',
                    name: '标准下限',
                    bindField: 'bzxx',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: true,
                  },
                  {
                    key: 'db9ebbbaee0445c2a3a377722a25bdf9',
                    name: '是否必填',
                    bindField: 'bt',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: false,
                  },
                  {
                    key: '770acd4156fb42e9a6c4be7473d7e54b',
                    name: '备注',
                    bindField: 'bz',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: false,
                  },
                  {
                    key: 'e2072cf51b084cebad1211d2898af9a8',
                    name: '巡检项ID',
                    bindField: 'xjxid',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: true,
                  },
                ],
                showColunmSet: false,
              },
            },
          ],
        },
      ],
      componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const formButtons = [
  {
    key: 'confirm',
    code: 'confirm',
    name: '确定',
    style: 'primary',
    event: [],
    isShow: true,
    index: 2,
    type: 1,
  },
  {
    key: 'cancel',
    code: 'cancel',
    name: '取消',
    style: 'default',
    event: [],
    isShow: true,
    index: 1,
    type: 1,
  },
  {
    key: 'reset',
    code: 'reset',
    name: '重置',
    style: 'default',
    event: [],
    isShow: true,
    index: 0,
    type: 1,
  },
];
