import datetime
import json
import logging

from collections import defaultdict

import pymssql
import pytz
from odoo.exceptions import ValidationError
from odoo import models, fields, api, http, SUPERUSER_ID, _
from odoo.addons.roke_workstation_api.controllers.picking import RokeWorkstationPicking

_logger = logging.getLogger(__name__)


def get_time_difference(user_tz):
    return user_tz.utcoffset(
        datetime.datetime.utcnow()
    ).total_seconds() / 3600


class InheritRokeWorkstationPicking(RokeWorkstationPicking):
    @http.route('/roke/dws/picking/demand', type='json', auth='user', csrf=False, cors="*")
    def dws_picking_demand(self, **kwargs):
        kwargs = kwargs if kwargs else http.request.jsonrequest
        task_ids = kwargs.get('task_ids', False)
        if not task_ids:
            return {"code": 1, "message": "缺少必要参数 task_ids", "data": None}

        task_model = http.request.env['roke.production.task']
        task_objs = task_model.sudo().browse(task_ids)

        picking_type_id = http.request.env.ref(
            'roke_mes_stock.stock_picking_type_production_out',
            raise_if_not_found=False
        )
        default_src_location_id = picking_type_id.src_location_id.id
        line_data = []
        system_id = http.request.env.ref("roke_workstation_sync_ps.roke_workstation_sync_ps_integrate_system")
        sync_address = system_id.sync_address
        sync_port = system_id.sync_port
        sync_uname = system_id.sync_uname
        sync_passwd = system_id.sync_passwd
        db_name = system_id.db_name
        try:
            conn = pymssql.connect(host=sync_address, user=sync_uname, password=sync_passwd, database=db_name)
            cur = conn.cursor()
        except Exception as e:
            return {"code": 1, "message": "数据库链接失败，请检查数据库链接参数", "data": None}
        for v in task_objs:
            try:
                cur.execute(f"""
                            select jswlzd_wlbh as wlbh,(jsbom_zxsl /jsbom_fxsl) as compare
                            from JSBOM, jswlzd 
                            where JSBOM_FXLS = '{self.flowing_water}'
                            and JSBOM_ZXLS =JSWLZD_LSBH
                        """)
                rows = cur.fetchall()
                rowdesc = cur.description
            except Exception as e:
                return {"code": 1, "message": "数据库查询失败", "data": None}
            finally:
                cur.close()
                conn.close()
            rows_data = [
                dict(zip([col[0] for col in rowdesc], row))
                for row in rows
            ]
            for row in rows_data:
                product = http.request.env["roke.product"].sudo().search([("code", "=", v.get("wlbh", ""))], limit=1)
                line_data.append({
                    "pt_demand_id": product.id,
                    "task_id": v.id,
                    "picking_type_id": picking_type_id.id,
                    "material_id": product.id,
                    "material_name": product.name,
                    "demand_qty": v.plan_qty * row.get("compare", 1),
                    "qty": v.plan_qty * row.get("compare", 1),
                    "lot_code": ""
                })
        data = {
            "default_src_location_id": default_src_location_id,
            "line_data": line_data,
        }
        return {"code": 0, "message": "success", "data": data}

    @http.route('/roke/dws/picking/create', type='json', auth='user', csrf=False, cors="*")
    def dws_picking_create(self, **kwargs):
        kwargs = kwargs if kwargs else http.request.jsonrequest

        picking_date = kwargs.get('picking_date', False)
        delivery_time = kwargs.get('delivery_time', False)
        src_location_id = kwargs.get('src_location_id', False)
        picking_user_id = kwargs.get('picking_user_id', False)
        line_data = kwargs.get('line_data', [])
        res = super(InheritRokeWorkstationPicking, self).dws_picking_create()
        if res.get("code", 1) == 1:
            return res
        task_id_dict = []
        for v in line_data:
            product = http.request.env["roke.product"].sudo().search([("id", v.get("material_id", 0))])
            task_id = http.request.env["roke.production.task"].sudo().search([("id", v.get("task_id", 0))])
            task_id_dict.append({
                "material_code": product.code or "",
                "code": task_id.code or "",
                "qty": v.get("qty", 0),
                "demand_qty": v.get("demand_qty", 0)
            })
        system_id = self.env.ref("roke_workstation_sync_ps.roke_workstation_sync_ps_integrate_system")
        sync_address = system_id.sync_address
        sync_port = system_id.sync_port
        sync_uname = system_id.sync_uname
        sync_passwd = system_id.sync_passwd
        db_name = system_id.db_name
        try:
            conn = pymssql.connect(host=sync_address, user=sync_uname, password=sync_passwd, database=db_name)
            cur = conn.cursor()
        except Exception as e:
            return {"code": 1, "message": "数据库链接失败，请检查数据库链接参数", "data": None}
        sql = """
            INSERT INTO WBLLD (WBLLD_RWBH, WBLLD_CPBH, WBLLD_XQSL, WBLLD_LLSL, WBLLD_datetime)
            VALUES 
        """
        sql_list = []
        for v in task_id_dict:
            sql_list.append(f"""
                ('{v.get("code", "")}', '{v.get("material_code", "")}', {v.get("demand_qty", 0)}, {v.get("qty", 0)}, '{datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")}')
            """)
        if not sql_list:
            return {"code": 1, "message": "数据错误，请检查数据结构", "data": None}
        sql += " , ".join(sql_list)
        try:
            cur.execute(sql)
            conn.commit()
        except Exception as e:
            return {"code": 1, "message": "数据上传失败", "data": None}
        finally:
            cur.close()
            conn.close()
        return res
