# -*- coding: utf-8 -*-
import http.client
import mimetypes
import math
from codecs import encode
from datetime import timedelta

from odoo import models, fields, api, _
from odoo.exceptions import ValidationError


class InheritProductionTask(models.Model):
    _inherit = "roke.production.task"

    file_ids = fields.Many2many("ir.attachment", "roke_production_task_ir_attachment", "pro_id", "att_id")

    work_order_hours = fields.Float(string="总报工时", compute="_compute_work_order_hours")

    @api.depends('work_order_ids')
    def _compute_work_order_hours(self):
        for record in self:
            record.work_order_hours = sum(record.work_order_ids.mapped("work_hours"))

    def write(self, vals):
        res = super(InheritProductionTask, self).write(vals)
        if vals.get('file_ids'):
            files = []
            for i in self.file_ids:
                a = self.env['documents.document'].create({
                    'attachment_id': i.id,
                    'folder_id': 2})
                files.append(a.id)
                self.document_ids = [(4, a.id)]
        return res

    def change_routing_id_work_order(self, routing):
        product = self.product_id
        plan_qty = self.plan_qty
        task_type = self.type
        routing_lines = self.get_create_wo_routing_lines(routing)
        work_orders = [(5, 0, 0)]
        date_num = (self.plan_date - self.plan_start_date).days
        work_order_num = len(routing_lines)
        if date_num == 0:
            for routing_line in routing_lines:
                date = self.plan_start_date
                work_order_data = self._get_new_work_order_data(routing_line, product, plan_qty, task_type)
                work_order_data['planned_start_time'] = date
                work_order_data['plan_date'] = date
                work_order_data['priority'] = self.priority
                work_orders.append((0, 0, work_order_data))
        else:
            num = work_order_num // date_num
            if num < 1:
                num = 1
            day = 0
            circulation_num = 1
            for routing_line in routing_lines:
                date = self.plan_start_date + timedelta(days=day)
                if circulation_num == num:
                    circulation_num = 1
                    if day + 1 <= date_num:
                        day += 1
                else:
                    circulation_num += 1
                work_order_data = self._get_new_work_order_data(routing_line, product, plan_qty, task_type)
                work_order_data['planned_start_time'] = date
                work_order_data['plan_date'] = date
                work_order_data['priority'] = self.priority
                work_orders.append((0, 0, work_order_data))
        return work_orders

    def craft_design(self):
        if self.record_ids and not self.routing_id.routing_task_id:
            raise ValidationError("该任务已报工，无法生成新的工艺设计。")
        if not self.routing_id:
            routing_id = self.env["roke.routing"].create({
                "name": f"{self.product_id.name}({self.code})" or "",
                "routing_task_id": self.id
            })
            self.write({
                "routing_id": routing_id.id,
            })
            self.write({
                "work_order_ids": self.change_routing_id_work_order(routing_id)
            })
        elif not self.routing_id.routing_task_id or self.routing_id.routing_task_id.id != self.id:
            routing_id = self.routing_id.copy()
            routing_id.update({
                "name": f"{routing_id.name}({self.code})",
                "routing_task_id": self.id
            })
            self.write({"routing_id": routing_id.id})
            self.write({
                "work_order_ids": self.change_routing_id_work_order(routing_id)
            })
        else:
            routing_id = self.routing_id
        return {
            "name": f"工艺设计({self.code})",
            "type": "ir.actions.client",
            "tag": "jzjx_project.roke_craft_design",
            "target": "current",
            "params": {
                "controller": f"/roke/craft_design/index?product_id={self.product_id.id}&routing_id={routing_id.id}"
            }
        }
