import logging
import pytz
from odoo import models, fields, api, http, SUPERUSER_ID, _
_logger = logging.getLogger(__name__)


class RokeWorkstationMaterial(http.Controller):

    @http.route('/roke/workstation/guidance/bulk_copy', type='http', auth="none", cors='*', csrf=False)
    def bulk_copy_roke_workstation_guidance(self):
        """
        工艺设计复制工艺文件接口
        """
        _self = http.request
        routing_line_ids = _self.jsonrequest.get("routing_line_ids", [])
        document_id = _self.jsonrequest.get("document_id", False)
        if not routing_line_ids or not document_id:
            return {"code": 1, "message": "入参错误！请检查入参数据。"}
        line_ids = _self.env["roke.routing.line"].sudo().search([("id", "in", routing_line_ids)])
        if not line_ids:
            return {"code": 1, "message": "校验失败！没有找到对应的明细数据。"}
        line_ids.write({
            "document_ids": [(4, int(document_id))]
        })
        return {"code": 0, "message": "复制成功"}

