from odoo import models, fields, api, _


class RokeEntrustIssueRecordModel(models.Model):

    _name = "roke.entrust.issue.record"
    _description = "委外发料记录"
    _rec_name = "code"

    code = fields.Char(string="编号",
                       default=lambda self: self.env['ir.sequence'].next_by_code('roke.entrust.issue.record.code'))

    material_ids = fields.Many2many("roke.send.material.record", string="委外发料记录")


class InheritRokeSendMaterialRecordModel(models.Model):

    _inherit = "roke.send.material.record"

    process_id = fields.Many2one(related="material_id.process_id", string="工序", store=True)
    entrust_customer = fields.Many2one(related="material_id.entrust_customer", string="委外客户", store=True)

    material = fields.Char(related="product_id.material", string="材质", store=True)
    hardness_requirements = fields.Char(related="product_id.hardness_requirements", string="硬度要求", store=True)
