from odoo import models, fields, api, _


class InheritRokeRoutingLine(models.Model):
    _inherit = "roke.routing.line"

    rated_working_hours = fields.Float(string='标准工时', help='工序的标准工时(小时)')
    special_process = fields.Selection([('是', '是'), ('否', '否')], string="特殊工序", default='否')


class InheritRokeRouting(models.Model):
    _inherit = "roke.routing"

    def get_routing_line_value(self, line):
        """
                获取工艺明细内容
                :param process:
                :return:
                """
        res = super(InheritRokeRouting, self).get_routing_line_value(line)
        res.update({
            "special_process": line.special_process,
            "p_bom_ids": [
                (0, 0, {
                    "product_id": v.product_id.id,
                    "protection_code": v.protection_code,
                    "qty": v.qty,
                })
                for v in line.p_bom_ids
            ],
            "scrap_reason_ids": [(6, 0, line.scrap_reason_ids.ids)],
            "check_ids": [
                (0, 0, {
                    "sequence": check_id.sequence,
                    "input_type": check_id.input_type,
                    "name": check_id.name or "",
                    "description": check_id.description or "",
                    "select_item_ids": [
                        (0, 0, {"id": item_id.id, "value": item_id.value or ""})
                        for item_id in check_id.select_item_ids
                    ],
                    "standard_value": check_id.standard_value,
                    "upper_value": check_id.upper_value,
                    "lower_value": check_id.lower_value,
                })
                for check_id in line.check_ids
            ],
            "standard_item_ids": [
                (0, 0, {
                    "title": standard.title,
                    "name": standard.name,
                    "description": standard.description or "",
                    "sequence": standard.sequence,
                    "upper_value": standard.upper_value,
                    "lower_value": standard.lower_value
                })
                for standard in line.standard_item_ids
            ]
        })
        return res


class InheritRokeProcess(models.Model):
    _inherit = "roke.process"

    rated_working_hours = fields.Float(string='标准工时', help='工序的标准工时(小时)')
