import logging
import pytz
import xlwt
from io import BytesIO
import base64
from odoo.osv import expression
from odoo import models, fields, api, http, SUPERUSER_ID, _
from odoo.addons.roke_mes_salary.controller.excel import ExcelDownloadController


class InheritExcelDownloadController(ExcelDownloadController):

    def _data_make_excel(self, order_line):
        """
        生成 Excel 文件
        """
        # 创建DataFrame对象
        result = [
            ['员工', '产品名称', '型号', '数量', '计件薪酬'],
        ]
        for order in order_line:
            for v in order.confirm_order_line_ids:
                result.append([
                    order.employee_id.name or '',
                    v.product_id.name or '',
                    v.product_id.model or '',
                    v.finish_qty or 0,
                    v.salary or 0
                ])
        wbk = xlwt.Workbook()
        sheet = wbk.add_sheet('Sheet1', cell_overwrite_ok=True)
        for i in range(len(result)):
            for j in range(len(result[i])):
                sheet.write(i, j, result[i][j])
        buffer = BytesIO()
        wbk.save(buffer)
        data = base64.encodebytes(buffer.getvalue())
        return data
