from odoo import models, fields, api
from odoo.exceptions import UserError, ValidationError


class JzjxInheritConfigSettings(models.TransientModel):
    _inherit = 'res.config.settings'

    refix_auto_work_order = fields.Boolean(string="返修自动生产工单", default=False)

    @api.model
    def get_values(self):
        res = super(JzjxInheritConfigSettings, self).get_values()
        refix_auto_work_order = self.env['ir.config_parameter'].sudo().get_param("refix_auto_work_order")
        res.update(
            refix_auto_work_order=refix_auto_work_order
        )
        return res

    def set_values(self):
        super(JzjxInheritConfigSettings, self).set_values()
        self.env['ir.config_parameter'].sudo().set_param('refix_auto_work_order', self.refix_auto_work_order)

    def get_refix_params(self):
        return self.refix_auto_work_order
