# -*- coding: utf-8 -*-
import http.client
import mimetypes
from codecs import encode
from odoo import models, fields, api, _
from odoo.exceptions import ValidationError


class InheritProductionTask(models.Model):
    _inherit = "roke.production.task"

    file_ids = fields.Many2many("ir.attachment", "roke_production_task_ir_attachment", "pro_id", "att_id")
    taskName = fields.Char(string="任务名称")
    UploadMsg = fields.Char(string="上传状态")
    TaskUUID = fields.Char(string="任务UUID")

    def upload_task(self):
        """
        上传任务 TODO 任务数量取计划数还是计划数-完成数？上传一次后还能再上传不？多个加工文件时，上传第一个还是最后一个？
        :return:
        """
        self.ensure_one()
        if not self.work_center_id:
            raise ValidationError("未指派工作中心，禁止上传")
        if not self.work_center_id.card_id:
            raise ValidationError("当前工作中心无控制卡信息，无法上传")
        if not self.file_ids:
            raise ValidationError("当前任务无加工文件，无法上传")
        if not self.taskName:
            raise ValidationError("必须填写任务名称")
        attachment = self.file_ids[:1]
        self.work_center_id.upload_task(self, attachment)

    def write(self, vals):
        res = super(InheritProductionTask, self).write(vals)
        if vals.get('file_ids'):
            files = []
            for i in self.file_ids:
                a = self.env['documents.document'].create({
                    'attachment_id': i.id,
                    'folder_id': 2})
                files.append(a.id)
                self.document_ids = [(4, a.id)]
        return res

