from odoo import models, fields, api, _
from datetime import datetime
from odoo.exceptions import UserError


class InheritTransportationProductInfoWizard(models.TransientModel):
    _inherit = "transportation.product.info.wizard"

    def confirm(self):
        # 是否生成委外调拨单
        if not self.move_line_ids:
            raise UserError('发料明细为空!')
        setting = self.env['ir.config_parameter'].sudo().get_param('entrust.stock.type', default='禁止')
        material_ids = []
        if setting == '允许':
            for entrust_id in self.entrust_ids:
                move_ids = self.move_line_ids.filtered(lambda v: v.origin_work_id.id == entrust_id.id and v.qty > 0)
                move_list = []
                for move in move_ids:
                    # 取出明细
                    move_list.append((0, 0, self._get_move_list_vals(move)))
                data = {
                    'state': self.state,
                    'picking_type_id': self.picking_type_id.id,
                    'type': self.type,
                    'partner_id': move_ids[0].partner_id.id if move_ids else False,
                    'src_location_id': self.src_location_id.id,
                    'dest_location_id': self.dest_location_id.id,
                    'picking_date': self.picking_date,
                    'origin': entrust_id.code,
                    'employee_id': self.employee_id.id,
                    'note': self.note,
                    'move_line_ids': move_list
                }
                # 创建调拨单
                picking = self.env["roke.mes.stock.picking"].create(data)
                entrust_id.write({
                    'entrust_state': '已发料',
                    'wo_start_state': '已开工',
                    'material_ids':move_list,
                    'send_entrust_date':datetime.utcnow(),
                    'entrust_id': picking.id,
                    'picking_count': entrust_id.picking_count + 1
                })
                material_ids += entrust_id.material_ids.ids
        else:
            for entrust_id in self.entrust_ids:
                move_ids = self.move_line_ids.filtered(lambda v: v.origin_work_id.id == entrust_id.id and v.qty > 0)
                move_list = []
                for move in move_ids:
                    # 取出明细
                    move_list.append((0, 0, self._get_move_list_vals(move)))
                # 写入工单发料记录
                entrust_id.write({
                    'entrust_state': '已发料',
                    'wo_start_state': '已开工',
                    'material_ids': move_list,
                    'send_entrust_date': datetime.utcnow()
                })
                material_ids += entrust_id.material_ids.ids
        self.env["roke.entrust.issue.record"].sudo().create({"material_ids": [(6, 0, material_ids)]})
