import datetime

import pymssql
import logging
from odoo import models, fields, api, _
from odoo.exceptions import ValidationError
_logger = logging.getLogger(__name__)


# 修正数量
class InheritRokeResultPutWarehouseWizard(models.TransientModel):
    _inherit = "roke.result.put.warehouse.wizard"

    @api.model
    def default_get(self, field_names):
        if self.env.context.get('active_model') != "roke.production.result":
            return super(InheritRokeResultPutWarehouseWizard, self).default_get(field_names)
        results = self.env['roke.production.result'].browse(self.env.context.get('active_ids'))
        system_id = self.env.ref("roke_workstation_sync_ps.roke_workstation_sync_ps_integrate_system")
        sync_address = system_id.sync_address
        sync_port = system_id.sync_port
        sync_uname = system_id.sync_uname
        sync_passwd = system_id.sync_passwd
        db_name = system_id.db_name
        try:
            conn = pymssql.connect(host=sync_address, user=sync_uname, password=sync_passwd, database=db_name)
            cur = conn.cursor()
        except Exception as e:
            raise ValidationError("数据库链接失败，请检查数据库链接参数")
        ids_str = [f"'{v.id}'" for v in results]
        if not ids_str:
            return super(InheritRokeResultPutWarehouseWizard, self).default_get(field_names)
        sql = f"""
            select WBCCB_CCID
            from WBCCB 
            where WBCCB_CCID in ({' , '.join(ids_str)})
        """
        try:
            cur.execute(sql)
            rows = cur.fetchall()
            rowdesc = cur.description
        except Exception as e:
            cur.close()
            conn.close()
            raise ValidationError("数据库查询失败")

        rows_data = [
            dict(zip([col[0] for col in rowdesc], row))
            for row in rows
        ]
        insert_id = []
        for v in rows_data:
            insert_id.append(v.get("WBCCB_CCID", 0))

        em = self.env["roke.employee"].search([("user_id", "=", self.env.uid)], limit=1)
        insert_sql_data = []
        for v in results:
            if v.id in insert_id:
                continue
            insert_sql_data.append(f"""
                ('{v.product_id.code}', '{v.wo_id.code}', {v.qty or 0}, {v.id}, '{v.pt_id.code}', '{v.pt_id.task_type}',
                 '{datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")}', '{em.code or ""}', '{em.name or ""}')
            """)
        sql = """
            INSERT INTO WBCCB (WBCCB_CPBH, WBCCB_GDBH, WBCCB_CCSL, WBCCB_CCID, WBCCB_RWBH, WBCCB_RWLX, WBCCB_datetime, WBCCB_YGBH, WBCCB_YGMC)
            VALUES 
        """
        if not insert_sql_data:
            return super(InheritRokeResultPutWarehouseWizard, self).default_get(field_names)
        sql += " , ".join(insert_sql_data)
        try:
            cur.execute(sql)
            conn.commit()
        except Exception as e:
            raise ValidationError("数据上传失败")
        finally:
            cur.close()
            conn.close()
        return super(InheritRokeResultPutWarehouseWizard, self).default_get(field_names)
