import logging
import datetime
import pymssql
from odoo.exceptions import ValidationError
from odoo import models, fields, api, _, SUPERUSER_ID
_logger = logging.getLogger(__name__)
_s_date = datetime.date(1899, 12, 31).toordinal() - 1


class InheritRokeBomCreatePickingWizard(models.TransientModel):
    _inherit = "roke.bom.create.picking.wizard"

    def confirm(self):
        res = super(InheritRokeBomCreatePickingWizard, self).confirm()
        task_id = self.env["roke.production.task"].browse(self._context.get('active_id'))
        system_id = self.env.ref("roke_workstation_sync_ps.roke_workstation_sync_ps_integrate_system")
        sync_address = system_id.sync_address
        sync_port = system_id.sync_port
        sync_uname = system_id.sync_uname
        sync_passwd = system_id.sync_passwd
        db_name = system_id.db_name
        try:
            conn = pymssql.connect(host=sync_address, user=sync_uname, password=sync_passwd, database=db_name)
            cur = conn.cursor()
        except Exception as e:
            raise ValidationError("数据库链接失败，请检查数据库链接参数")
        sql = """
            INSERT INTO WBLLD (WBLLB_RWBH, WBLLB_CPBH, WBLLB_XQSL, WBLLB_LLSL)
            VALUES 
        """
        sql_list = []
        for v in self.line_ids:
            sql_list.append(f"""
                ('{task_id.code}', '{v.material_id.code}', '{v.demand_qty}', '{v.qty}')
            """)
        if not sql_list:
            raise ValidationError("数据错误")
        sql += " , ".join(sql_list)
        try:
            cur.execute()
            conn.commit()
        except Exception as e:
            raise ValidationError("数据库查询失败")
        finally:
            cur.close()
            conn.close()
        return res
