from odoo import models, fields, api

class ProductImportWizard(models.TransientModel):
    _name = 'product.import.wizard'
    _description = '产品导入向导'

    product_ids = fields.Many2many('roke.product', string='选择产品')

    def import_products(self):
        active_id = self.env.context.get('active_id')
        process = self.env['roke.process'].browse(active_id)
        process.product_salary_ids = [(0, 0, {"product_id": v}) for v in self.product_ids.ids]
