from odoo import models, fields, api


class AssignWorkcenterWizard(models.TransientModel):
    _name = 'assign.work.center.wizard'
    _description = '指派工作中心向导'

    workshop_id = fields.Many2one('roke.workshop', string='产线')
    work_center_id = fields.Many2one('roke.work.center', string='工位')
    work_order_id = fields.Many2one('roke.work.order', string='工单')

    def action_confirm(self):
        self.ensure_one()
        if self.work_order_id and self.work_center_id:
            self.work_order_id.write({
                'work_center_id': self.work_center_id.id
            })
        return {'type': 'ir.actions.act_window_close'}
