import requests
from odoo import models, fields, api, _
from odoo.exceptions import UserError
import psycopg2, pymssql, cx_Oracle
import json
import logging
import datetime

_logger = logging.getLogger(__name__)


class RokePubIntegrateModel(models.Model):

    _inherit = "roke.pub.integrate.model"

    time_type = fields.Selection(selection_add=[("YMD", "YMD")], string="时间类型")

    def sync_pull_database(self, **kwargs):
        _logger.info("----------------------******数据库直连下拉数据******----------------------")
        sync_address = self.system_id.sync_address
        sync_port = self.system_id.sync_port
        sync_uname = self.system_id.sync_uname
        sync_passwd = self.system_id.sync_passwd
        db_name = self.system_id.db_name
        if self.db_type == 'PostgreSQL':
            conn = psycopg2.connect(host=sync_address, port=int(sync_port), user=sync_uname, password=sync_passwd,
                                    database=db_name)
            cur = conn.cursor()
        elif self.db_type == 'Microsoft SQL Server':
            # conn = pymssql.connect(host="%s:%s" % (sync_address, sync_port), user=sync_uname, password=sync_passwd, database=db_name)
            conn = pymssql.connect(host=sync_address, user=sync_uname, password=sync_passwd, database=db_name)
            cur = conn.cursor()
        elif self.db_type == 'oracle':
            conn = cx_Oracle.connect(sync_uname, sync_passwd, '%s:%s/ORCL' % (sync_address, sync_port))
            cur = conn.cursor()
        else:
            raise UserError('非预制类型')
        wheresql = ""
        # 时间轴字段where条件拼接
        if self.sync_mode == "时间轴" and self.time_axis_field and self.last_execute_time:
            if self.time_type == "Y-M-D H:M:S":
                wheresql += " and %s >= '%s'" % (self.time_axis_field, self.last_execute_time.strftime("%Y-%m-%d %H:%M:%S"))
            elif self.time_type == "YMD HMS":
                wheresql += " and %s >= '%s'" % (self.time_axis_field, self.last_execute_time.strftime("%Y%m%d %H%M%S"))
            else:
                wheresql += " and %s >= %s" % (self.time_axis_field, self.last_execute_time.strftime("%Y%m%d"))
        # 填写的where条件拼接
        if self.where_sql:
            wheresql += self.where_sql
        # 入参where条件拼接
        for integrate_input in self.integrate_input_ids:
            if integrate_input.is_required and not integrate_input.fixed:
                if not kwargs.get(integrate_input.enter_name):
                    raise UserError("入参[%s]必填!" % integrate_input.enter_name)
                wheresql += " and %s='%s'" % (integrate_input.enter_name, kwargs.get(integrate_input.enter_name))
            else:
                if integrate_input.fixed:
                    wheresql += " and %s='%s'" % (integrate_input.enter_name, integrate_input.enter_data)
        # 拼接查询字段
        select_field = ""
        for integrate_field in self.integrate_field_ids:
            if not integrate_field.fixed:
                select_field += "%s, " % integrate_field.opposite_field_name
        select_field = select_field[:-2]
        cur.execute("select {} from {} where 1=1 {}".format(select_field, self.opposite_model, wheresql))
        rows = cur.fetchall()
        rowdesc = cur.description
        data_dicts = [
            dict(zip([col[0] for col in rowdesc], row))
            for row in rows
        ]
        cur.close()
        conn.close()
        self.sync_analysis_database(data_dicts)
        if self.logging_enable:
            self.env["roke.pub.integrate.log"].create({
                "requst_parameter": wheresql,
                "response_result": str(data_dicts),
                "integrate_model_id": self.id,
            })
