import datetime
import pymysql
import logging
from odoo import api, models, fields

_logger = logging.getLogger(__name__)


class InheritRokeRoutingModel(models.Model):
    _inherit = "roke.routing"

    routing_task_id = fields.Many2one("roke.production.task")

    def _get_check_vals(self, check):
        data = {
            "sequence": check.sequence,
            "name": check.name,
            "description": check.description,
            "input_type": check.input_type,
            "standard_value": check.standard_value,
            "upper_value": check.upper_value,
            "lower_value": check.lower_value,
        }
        check_option = []
        for v in check.select_item_ids:
            check_option.append((0, 0, {
                "sequence": v.sequence,
                "value": v.value
            }))
        data.update({
            "select_item_ids": check_option
        })
        return data

    def get_routing_line_value(self, line):
        """
        获取工艺明细内容
        :param process:
        :return:
        """
        res = super(InheritRokeRoutingModel, self).get_routing_line_value(line)
        check_ids = []
        for v in line.check_ids:
            check_ids.append((0, 0, self._get_check_vals(v)))
        res.update({
            "scrap_reason_ids": [(6, 0, line.scrap_reason_ids.ids)],
            "check_ids": check_ids,
        })
        return res

    def _get_standard_item_vals(self, standard_item):
        """
        作业规范
        """
        res = super(InheritRokeRoutingModel, self)._get_standard_item_vals(standard_item)
        res.update({
            "description": standard_item.description or "",
            "sequence": standard_item.sequence,
        })
        return res
