from odoo import models, fields, api, http, SUPERUSER_ID, _
from odoo.addons.roke_workstation_api.controllers.product_task import RokeWorkstationProductionTask
import logging
import math

_logger = logging.getLogger(__name__)


class JzjxInheritRokeWorkstationProductionTask(RokeWorkstationProductionTask):

    @http.route('/roke/workstation/product_task/machine_get_list', type='json', auth='user', csrf=False, cors="*")
    def product_task_machine_get_list(self):
        """
        获取当前用户权限下所有任务的数据
        workstation_id: int 工位ID
        limit: int 条数
        page: int 页数
        """
        _self = http.request
        workstation_id = _self.jsonrequest.get("workstation_id", False)
        limit = _self.jsonrequest.get("limit", 20)
        page = _self.jsonrequest.get("page", 1)

        if not workstation_id:
            return {"code": 1, "message": f"入参错误！ “工位ID”为必传数据。", "data": []}
        workstation = _self.env["roke.work.center"].search(
            [("id", "=", workstation_id)])
        if not workstation:
            return {"code": 1, "message": "校验错误！ 未找到该工位数据。", "data": []}
        user_id = _self.env['roke.employee'].search(
            [('user_id', '=', http.request.uid)], limit=1)
        process_ids = _self.env['roke.process'].search(
            [('workstation_ids', '=', workstation_id)])
        # process_list = list(set(process_ids.ids) & set(user_id.process_ids.ids))
        process_list = process_ids.ids
        domain = [
            ("task_id.workshop_id", "=", workstation.workshop_id.id),
            ("process_id", "in", process_list),
            ("state", "in", ["未完工", "暂停"])
        ]
        work_order = _self.env["roke.work.order"].search(domain)
        sql = f"""
            SELECT id, type, create_date
            FROM (
                {f'''SELECT roke_production_task.id, 'task' as "type", roke_production_task.create_date
                FROM roke_production_task LEFT JOIN roke_work_order on roke_work_order.task_id = roke_production_task.id
                WHERE roke_work_order.id in ({" , ".join([f"{v}" for v in work_order.ids])})
                and roke_production_task.state in ('未完工', '暂停')
                union all''' if work_order.ids else ""}
                SELECT id, 'work' as "type", create_date
                FROM roke_work_order
                WHERE type in ('返修', '补件')
                and process_id in ({" , ".join([f"{v}" for v in process_list])})
                and state = '未完工'
                and task_id is null
            ) as task_repair_work
            ORDER BY create_date desc
            LIMIT {limit}
            offset {(page - 1) * limit}
        """
        _self.env.cr.execute(sql)
        results = _self.env.cr.dictfetchall()
        count_sql = f"""
            SELECT count(id)
            FROM (
                {f'''SELECT roke_production_task.id
                FROM roke_production_task LEFT JOIN roke_work_order on roke_work_order.task_id = roke_production_task.id
                WHERE roke_work_order.id in ({" , ".join([f"{v}" for v in work_order.ids])})
                and roke_production_task.state in ('未完工', '暂停')
                union all''' if work_order.ids else ""}
                SELECT id
                FROM roke_work_order
                WHERE type = '返修'
                and process_id in ({" , ".join([f"{v}" for v in process_list])})
                and state = '未完工'
                and repair_task_id is not null
            ) as task_repair_work
        """
        _self.env.cr.execute(count_sql)
        task_count = _self.env.cr.dictfetchall()[0].get("count", 0)
        ids_list = []
        task_id_list = []
        work_id_list = []
        for v in results:
            data_type = v.get("type", '')
            data_id = v.get("id", 0)
            ids_list.append([data_id, data_type])
            if data_type == 'task':
                task_id_list.append(data_id)
            if data_type == 'work':
                work_id_list.append(data_id)
        task_ids = _self.env["roke.production.task"].search([("id", "in", task_id_list)])
        work_ids = _self.env["roke.work.order"].search([("id", "in", work_id_list)])
        task_data_dict = {}
        for v in task_ids:
            task_data_dict[str(v.id)] = {
                "id": v.id,
                "code": v.code,
                "state": v.state,
                "partner": {"id": v.customer_id.id or None, "name": v.customer_id.name or ""},
                "plan_qty": v.plan_qty or 0,
                "product": {"id": v.product_id.id or None, "name": v.product_id.name or ""},
                "priority": v.priority,
                "planned_start_time": v.plan_start_date.strftime('%Y-%m-%d') if v.plan_start_date else "",
                "plan_date": v.plan_date.strftime('%Y-%m-%d') if v.plan_date else "",
                "specification": v.product_id.specification or "",
                "model": v.product_id.model or "",
                "order_type": "task",
                "type": ""
            }
        work_data_dict = {}
        for v in work_ids:
            work_data_dict[str(v.id)] = {
                "id": v.id,
                "code": v.code,
                "state": v.state,
                "partner": {"id": v.customer_id.id or None, "name": v.customer_id.name or ""},
                "plan_qty": v.plan_qty or 0,
                "product": {"id": v.product_id.id or None, "name": v.product_id.name or ""},
                "priority": v.priority,
                "planned_start_time": v.planned_start_time.strftime('%Y-%m-%d') if v.planned_start_time else "",
                "plan_date": v.plan_date.strftime('%Y-%m-%d') if v.plan_date else "",
                "specification": v.product_id.specification or "",
                "model": v.product_id.model or "",
                "order_type": "work",
                "type": v.type
            }
        data = []
        for v in ids_list:
            l_id = v[0]
            l_type = v[1]
            if l_type == "task":
                task_data = task_data_dict.get(str(l_id), False)
                if not task_data:
                    continue
                data.append(task_data)
            if l_type == "work":
                work_data = work_data_dict.get(str(l_id), False)
                if not work_data:
                    continue
                data.append(work_data)
        return {"code": 0, "message": "获取成功！", "data": data, "process_ids": process_list, "count": task_count}
