from odoo import models, fields, api, _


class InheritWorkOrder(models.Model):
    _inherit = "roke.work.order"

    document_ids = fields.Many2many(related="task_id.document_ids", string="作业指导")
    task_file_ids = fields.Many2many(related="task_id.file_ids")
    repair_task_id = fields.Many2one('roke.production.task', string="返修上级任务")

    def write(self, vals):
        id_dict = {}
        for v in self:
            id_dict[str(v.id)] = v.state
        res = super(InheritWorkOrder, self).write(vals)
        for v in self:
            old_state = id_dict.get(str(v.id), "")
            if "state" not in vals.keys():
                return res
            state = vals.get("state", "")
            if state in ["已完工", "强制完成"]:
                repair_order_id = self.env["roke.repair.order.line"].sudo().search([
                    ("repair_work_order_id", "=", self.id)], limit=1)
                if repair_order_id:
                    repair_order_id.write({"state": "返修完成"})
                    repair_order_id.order_id.write({"state": "返修完成"})
            if state == "未完工" and old_state in ["暂停", "强制完工", "已完工"]:
                repair_order_id = self.env["roke.repair.order.line"].sudo().search([
                    ("repair_work_order_id", "=", self.id)], limit=1)
                if repair_order_id:
                    repair_order_id.write({"state": "返修中"})
                    repair_order_id.order_id.write({"state": "返修中"})
        return res

    def _get_production_multiple(self, previous):
        """
        获取当前生产倍数
        :param previous:
        :return:
        """
        judge = "切割" in self.process_id.name or "压铆" in self.process_id.name or "折弯" in self.process_id.name
        if not self.routing_line_id and not judge:
            # 无工艺明细直接返回
            return 1
        if "切割" in self.process_id.name:
            multiple = self.task_id.spare_parts_qty / self.task_id.plan_qty
        elif "压铆" in self.process_id.name:
            multiple = self.task_id.press_riveting_qty / self.task_id.plan_qty
        elif "折弯" in self.process_id.name:
            multiple = self.task_id.bending_qty / self.task_id.plan_qty
        else:
            multiple = self.routing_line_id.multiple
        if len(previous) > 1:
            # 取到最小数对应的前道工单
            rel_previous = self._multi_previous_get_min_finished(previous)
            rel_previous_judge = "切割" in rel_previous.process_id.name or "压铆" in rel_previous.process_id.name \
                                 or "折弯" in rel_previous.process_id.name
            if not rel_previous.routing_line_id.multiple and not rel_previous_judge:  # 无倍数直接返回
                return 1
            if "切割" in rel_previous.process_id.name:
                rel_previous_multiple = rel_previous.task_id.spare_parts_qty / rel_previous.task_id.plan_qty
            elif "压铆" in rel_previous.process_id.name:
                rel_previous_multiple = rel_previous.task_id.press_riveting_qty / rel_previous.task_id.plan_qty
            elif "折弯" in rel_previous.process_id.name:
                rel_previous_multiple = rel_previous.task_id.bending_qty / rel_previous.task_id.plan_qty
            else:
                rel_previous_multiple = rel_previous.routing_line_id.multiple
            return multiple / rel_previous_multiple
        if not previous.routing_line_id.multiple and not judge:  # 无倍数直接返回
            return 1
        elif not previous and judge:
            return 1

        if "切割" in previous.process_id.name:
            previous_multiple = previous.task_id.spare_parts_qty / self.task_id.plan_qty
        elif "压铆" in previous.process_id.name:
            previous_multiple = previous.task_id.press_riveting_qty / self.task_id.plan_qty
        elif "折弯" in previous.process_id.name:
            previous_multiple = previous.task_id.bending_qty / self.task_id.plan_qty
        else:
            previous_multiple = previous.routing_line_id.multiple
        return multiple / previous_multiple
