from odoo import models, fields, api, _
from odoo.exceptions import ValidationError


class InheritWorkOrder(models.Model):
    _inherit = "roke.work.order"

    document_ids = fields.Many2many(related="task_id.document_ids", string="作业指导")
    task_file_ids = fields.Many2many(related="task_id.file_ids")
    special_process = fields.Selection(related="routing_line_id.special_process")

    next_wo_id = fields.Many2one("roke.work.order", string="下道工单", store=True, compute="_compute_next_work_order")

    @api.depends("task_id")
    def _compute_next_work_order(self):
        for v in self:
            if v.type == "生产":
                sequence = min(v.mapped("sequence"))
                next_wos = v.task_id.work_order_ids.filtered(lambda wo: wo.sequence > sequence)
                next_wo = sorted(next_wos, key=lambda x: x['sequence'], reverse=False)
                if not next_wo:
                    continue
                v.next_wo_id = next_wo[0].id
            elif v.type == "返修":
                v.next_wo_id = v.repair_wr_id.work_order_id.id
            elif v.type == "补件":
                sequence = v.sequence
                next_wos = v.repair_wr_id.scrap_line_ids.scrap_work_order_ids.filtered(lambda wo: wo.sequence > sequence)
                next_wo = sorted(next_wos, key=lambda x: x['sequence'], reverse=False)
                if not next_wo:
                    v.next_wo_id = v.repair_wr_id.work_order_id.id
                else:
                    v.next_wo_id = next_wo[0].id

    def action_assign_work_center(self):
        self.ensure_one()
        # 检查是否是特殊工序 
        # 打开指派向导
        return {
            'name': '指派工作中心',
            'type': 'ir.actions.act_window',
            'res_model': 'assign.work.center.wizard',
            'view_mode': 'form',
            'target': 'new',
            'context': {
                'default_work_order_id': self.id,
            }
        }

    def _get_wo_allow_qty(self):
        if self.is_quality:
            # 质检工单的可报工数取被检工单的数量
            # 待检数=被检工单所有报工数合计
            allow_qty = sum(self.quality_origin_wo_id.record_ids.mapped("finish_qty")) + \
                        sum(self.quality_origin_wo_id.record_ids.mapped("unqualified_qty")) - \
                        self.quality_origin_wo_id.qualified_qty
            default_qty = allow_qty
        else:
            allow_qty, default_qty = super(InheritWorkOrder, self)._get_wo_allow_qty()
        return allow_qty, default_qty
