import datetime
import json
import os

from jinja2 import FileSystemLoader, Environment
from odoo import models, fields, api, http, SUPERUSER_ID, _
from odoo.addons.roke_mes_quality.controller.inherit_production import InheritProduction
from odoo.addons.roke_mes_production.controller.work_report import WorkReportKanban
import logging
import math

_logger = logging.getLogger(__name__)


class JzjxInheritProduction(InheritProduction):

    def _get_work_record_values(self, wo, values):
        """
        获取创建工单需要的数据：报工采集结果
        scrap_qty:报废数
        repair_qty:返修数
        scrap_list:报废明细---->[{"reason_id": 报废原因ID, "qty": 报废数量}]
        repair_list:返修明细---->[{"reason_id": 返修原因ID, "qty": 返修数量}]
        :param wo: 工单
        :param values: 入参
        :return:
        """
        res = super(JzjxInheritProduction, self)._get_work_record_values(wo, values)
        repair_process_id = values.get('process_id', False)  # 工序
        scrap_list, _ = values.get("scrap_list", []), values.get("repair_list", [])
        if repair_process_id:
            res.update({"repair_process_id": repair_process_id})
        no_scrap_detail_ids = []
        for scrap in scrap_list:
            scrap_qty = float(scrap.get("qty", 0))
            if scrap_qty:
                continue
            no_scrap_detail_ids.append((0, 0, {
                'reason_id': int(scrap.get("reason_id")),
                'qty': scrap_qty,
                'note': scrap.get("note")
            }))
        res.update({
            "scrap_detail_ids": res.get("scrap_detail_ids", []) + no_scrap_detail_ids,
        })
        return res

    def check_join_in_data(self, values):
        work_order_id = values.get('work_order_id', False)  # 工单ID
        product_id = values.get('product_id', False)  # 产品
        process_id = values.get('process_id', False)  # 工序
        finish_qty = float(values.get('finish_qty') or 0)  # 合格数量
        unqualified_qty = float(values.get('unqualified_qty') or 0)  # 不合格数量
        work_hours = float(values.get('work_hours') or 0)  # 工时数
        employee_list = values.get('employee_list', [])  # 人员分配：[{'employee_id':1, 'weighted': 1}]
        repair_qty = values.get('repair_qty', False)  # 人员分配：[{'employee_id':1, 'weighted': 1}]
        # 校验入参工单ID、产品、工序、人员列表、不合格数和报废数、返修数
        if not work_order_id and (not product_id or not process_id):
            return {"state": "error", "msgs": "无工单ID时表示无工单报工，必须入参产品ID和工序ID"}
        if not employee_list or type(employee_list) not in (list, tuple):
            return {"state": "error", "msgs": "请选择人员"}
        if (repair_qty and repair_qty < 0) or (float(finish_qty) < 0 or float(unqualified_qty) < 0):
            return {"state": "error", "msgs": "合格数或不合格数不得小于0"}
        # 判断是否能获取到辅计量数据
        aux_list = values.get('aux_list', [])  # 合格数量辅计量数据
        unaux_list = values.get('unaux_list', [])  # 不合格辅计量数据
        if aux_list or unaux_list:
            finish_aux_list = [aux.get('aux_qty', 0) for aux in aux_list if aux.get('aux_qty', 0) > 0]
            unqualified_aux_list = [aux.get('aux_qty', 0) for aux in unaux_list if aux.get('aux_qty', 0) > 0]
            if not float(finish_qty) and not float(unqualified_qty) and not float(
                    work_hours) and not finish_aux_list and not unqualified_aux_list:
                return {"state": "error", "msgs": "合格数或不合格数或工时数不可同时为0"}
        else:
            if not repair_qty and not float(finish_qty) and not float(unqualified_qty) and not float(work_hours):
                return {"state": "error", "msgs": "合格数或不合格数或工时数不可同时为0"}
        return False


class JzjxRokeRefixAutoWorkOrder(http.Controller):

    @http.route('/roke/config/get_refix_auto_work_order', type='json', auth='none', csrf=False, cors="*")
    def get_refix_auto_work_order(self):
        _self = http.request
        refix_params = _self.env['ir.config_parameter'].sudo().get_param("refix_auto_work_order")
        return {"code": 0, "message": "成功！", "state": refix_params == "True" or refix_params is True}

    @http.route('/roke/work_record/get_image_data', type='json', auth='user', csrf=False, cors="*")
    def work_record_get_image_data(self):
        """
        获取返修/报废工单的反馈图片
        """
        _self = http.request
        work_order_id = _self.jsonrequest.get("work_order_id", 0)
        if not work_order_id:
            return {"code": 1, "message": "入参错误！工单ID为必传参数。", "data": []}
        work_order = _self.env["roke.work.order"].search([("id", "=", work_order_id)])
        if not work_order:
            return {"code": 1, "message": "校验失败！未找到该工单数据。", "data": []}
        if work_order.type == "返修":
            scrap_order_line = _self.env["roke.repair.order.line"].search([
                ("repair_work_order_id", "=", work_order.id)
            ], limit=1)
            record_id = scrap_order_line.wr_id
        elif work_order.type == "补件":
            scrap_order_line = _self.env["roke.scrap.order.line"].search([("scrap_work_order_ids", "=", work_order.id)],
                                                                         limit=1)
            record_id = scrap_order_line.wr_id
        else:
            return {"code": 1, "message": "校验失败！该工单不是返修/报废工单。", "data": []}
        data_list = []
        attachment = _self.env['ir.attachment'].search([
            ("res_model", "=", "roke.work.record"), ("res_id", "=", record_id.id)
        ])
        for v in attachment:
            if not v.access_token:
                v.generate_access_token()
            url = f"/web/image/{v.id}?access_token={v.access_token}&unique={str(fields.Datetime.now().timestamp())}"
            data_list.append(url)
        return {"code": 0, "message": "获取成功！", "data": data_list, "note": record_id.note or ""}

    @http.route('/roke/mes/work_time/get', type='json', auth="user", csrf=False, cors='*')
    def get_work_time(self):
        """
        获取工时树
        :return:
        """
        uid = http.request.uid or http.request.session.uid
        if not uid:
            return {"code": 1, "message": "当前位置尚未登录，请先登录", "work_hours": 0}
        start_record = http.request.env(user=SUPERUSER_ID)['roke.work.start.record'].search([
            ("user_id", "=", uid),
            ("state", "=", "工作中")
        ], limit=1)
        if not start_record:
            return {"code": 1, "message": "未开工，请先开工。", "work_hours": 0}
        delta = datetime.datetime.now() - start_record.start_time
        work_hours = round(delta.total_seconds() / 3600, 2)
        return {"code": 0, "message": "获取成功！", "work_hours": work_hours}


BASE_DIR = os.path.dirname(os.path.dirname(__file__))
templateloader = FileSystemLoader(searchpath=BASE_DIR + "/static/src/html/view")
env = Environment(loader=templateloader)


class JzjxRokeWorkReportKanban(WorkReportKanban):

    @http.route('/roke/work/report/work_order_report', type='http', auth='public', csrf=False)
    def work_order_report(self):
        """工单报工"""
        values = {}
        # 修改Jinja2 分隔符
        env.variable_start_string = '[['
        env.variable_end_string = ']]'
        template = env.get_template('zdy_gdbg.html')
        html = template.render(values)
        return html
