import datetime

from odoo import models, fields, api, _
from odoo.exceptions import ValidationError


class InheritRokeCreateWorkRecordWizard(models.TransientModel):
    _inherit = "roke.create.work.record.wizard"

    repair_product_id = fields.Many2one("roke.process", string="工序")

    def create_other_order(self, new_record):
        """
        创建报废单、返修单
        生产返修工单
        :return:
        """
        res = super(InheritRokeCreateWorkRecordWizard, self).create_other_order(new_record)
        repair = res.get("repair", False)
        refix_params = self.env['ir.config_parameter'].sudo().get_param("refix_auto_work_order")
        if repair and self.repair_qty and (refix_params == "True" or refix_params is True) and self.repair_product_id:
            repair.is_refix_auto_work_order = refix_params == "True" or refix_params is True
            for v in repair.line_ids:
                repair_work_order_id = self.env["roke.work.order"].create({
                    "process_id": new_record.process_id.id,
                    "product_id": self.repair_product_id.id,
                    "plan_qty": v.qty,
                    "sequence": 1,
                    "planned_start_time": datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S'),
                    "plan_date": datetime.datetime.now().strftime('%Y-%m-%d') + " 23:59:59",
                    "repair_task_id": new_record.pt_id.id or repair.wo_id.repair_task_id.id,
                    "type": "返修"
                })
                data = {
                    "repair_work_order_id": repair_work_order_id,
                    "is_refix_auto_work_order": refix_params == "True" or refix_params is True
                }
                if repair_work_order_id.wo_start_state == '已开工':
                    data.update({"state": "返修中"})
                    repair.write({"state": "返修中"})
                v.write(data)
        return res
