import logging
from . import generator
from odoo import models, fields, api, _
_logger = logging.getLogger(__name__)


class JzjxInheritRepairOrder(models.Model):
    _inherit = "roke.repair.order"

    is_refix_auto_work_order = fields.Boolean(string="是否自动生产返修单")


class JzjxInheritRepairOrderLine(models.Model):
    _inherit = "roke.repair.order.line"

    repair_work_order_id = fields.Many2one("roke.work.order", string="返修工单")
    is_refix_auto_work_order = fields.Boolean(string="是否自动生产返修单")


class JzjxInheritWorkOrder(models.Model):
    _inherit = "roke.work.order"

    def write(self, vals):
        id_dict = {}
        for v in self:
            id_dict[str(v.id)] = v.state
        res = super(JzjxInheritWorkOrder, self).write(vals)
        for v in self:
            old_state = id_dict.get(str(v.id), "")
            if "state" not in vals.keys():
                return res
            state = vals.get("state", "")
            if state in ["已完工", "强制完成"]:
                repair_order_id = self.env["roke.repair.order.line"].sudo().search([
                    ("repair_work_order_id", "=", self.id)], limit=1)
                if repair_order_id:
                    repair_order_id.write({"state": "返修完成"})
                    repair_order_id.order_id.write({"state": "返修完成"})
            if state == "未完工" and old_state in ["暂停", "强制完工", "已完工"]:
                repair_order_id = self.env["roke.repair.order.line"].sudo().search([
                    ("repair_work_order_id", "=", self.id)], limit=1)
                if repair_order_id:
                    repair_order_id.write({"state": "返修中"})
                    repair_order_id.order_id.write({"state": "返修中"})
        return res
