from odoo import models, fields, api, http, SUPERUSER_ID, _
from odoo.addons.roke_mes_quality.controller.inherit_production import InheritProduction
import logging
import math

_logger = logging.getLogger(__name__)


class JzjxInheritProduction(InheritProduction):

    def _get_work_record_values(self, wo, values):
        """
        获取创建工单需要的数据：报工采集结果
        scrap_qty:报废数
        repair_qty:返修数
        scrap_list:报废明细---->[{"reason_id": 报废原因ID, "qty": 报废数量}]
        repair_list:返修明细---->[{"reason_id": 返修原因ID, "qty": 返修数量}]
        :param wo: 工单
        :param values: 入参
        :return:
        """
        res = super(JzjxInheritProduction, self)._get_work_record_values(wo, values)
        repair_product_id = values.get('process_id', False)  # 工序
        if repair_product_id:
            res.update({"repair_product_id": repair_product_id})
        return res
