from datetime import timedelta
from odoo import models, fields, api, _
from odoo.exceptions import ValidationError
from odoo.osv import expression


class InheritProductionTask(models.Model):
    _inherit = "roke.product"
    
    standard_hours = fields.Float(string='标准工时', help='产品的标准工时(小时)')
    mnemonic_aid_code = fields.Char(string="助记码")

    @api.model
    def _name_search(self, name, args=None, operator='ilike', limit=100, name_get_uid=None):
        import_file = self.env.context.get("import_file", False)
        if import_file:  # 如果是导入时的搜索，不重写过滤方法
            return super(InheritProductionTask, self)._name_search(
                name, args, operator=operator, limit=limit, name_get_uid=name_get_uid
            )

        args = args or []
        if operator == 'ilike' and not (name or '').strip():
            domain = []
        else:
            # 默认过滤条件，没有在设置中配置产品显示名称时使用
            # 当存在配置时，此domain将被覆盖
            if operator == 'ilike':
                domain = ['|', '|', ('name', 'ilike', name), ('code', '=', name), ("mnemonic_aid_code", "ilike", name)]

                product_display_names = self.env['ir.config_parameter'].sudo().get_param(
                    'product.display.name.ids', default=[]
                )

                if product_display_names:  # 查询到了配置，按情况覆盖domain
                    product_display_name_ids = [int(rec) for rec in product_display_names if rec.isdigit()]
                    search_field = [
                        rec.code for rec in
                        self.env['roke.product.display.name.settings'].browse(product_display_name_ids)
                    ]

                    # 有配置情况下的默认过滤条件，在给定字符串中包含特殊'【' 和 '】'符号且解析过程中没有异常时使用
                    # 如果给定字符串中包含特殊'【' 和 '】'符号且解析过程中没有异常，此domain将被覆盖
                    domain = ['|', ('name', 'ilike', name), ("mnemonic_aid_code", "ilike", name)]
                    for rec in search_field:
                        domain.insert(0, '|')
                        domain.append((rec, 'ilike', name))
                    try:
                        if "【" in name and "】" in name:  # 处理搜索完整的显示名称时，比如：产品名称【产品型号】
                            rel_name = name.split("【")[0]
                            search_field_val = name.split("【")[1].split("】")[0]
                            domain = [('name', 'ilike', rel_name)]
                            for rec in search_field:
                                domain.insert(0, '|')
                                domain.append((rec, 'ilike', search_field_val))
                    except Exception as e:
                        pass

                is_ks_search = self.env.context.get("is_ks_search", False)
                if is_ks_search:  # 如果是 ks_list_search 时的搜索，需要再过滤准确的值，因为上面的过滤使用了"或条件"且display_name不可被过滤
                    result = super(InheritProductionTask, self).search(domain + args)
                    result_ids = result.filtered(lambda r: name in r.display_name)
                    if result_ids:
                        domain = [("id", "in", result_ids.ids)]
            else:
                domain = [('name', operator, name)]
        return self._search(expression.AND([domain, args]), limit=limit, access_rights_uid=name_get_uid)

