from odoo import models, fields, api, http, SUPERUSER_ID, _
from odoo.addons.roke_mes_quality.controller.inherit_production import InheritProduction
import logging
import math

_logger = logging.getLogger(__name__)


class JzjxInheritProduction(InheritProduction):

    def _get_work_record_values(self, wo, values):
        """
        获取创建工单需要的数据：报工采集结果
        scrap_qty:报废数
        repair_qty:返修数
        scrap_list:报废明细---->[{"reason_id": 报废原因ID, "qty": 报废数量}]
        repair_list:返修明细---->[{"reason_id": 返修原因ID, "qty": 返修数量}]
        :param wo: 工单
        :param values: 入参
        :return:
        """
        res = super(JzjxInheritProduction, self)._get_work_record_values(wo, values)
        repair_process_id = values.get('process_id', False)  # 工序
        if repair_process_id:
            res.update({"repair_process_id": repair_process_id})
        return res


class JzjxRokeRefixAutoWorkOrder(http.Controller):

    @http.route('/roke/config/get_refix_auto_work_order', type='json', auth='none', csrf=False, cors="*")
    def get_refix_auto_work_order(self):
        _self = http.request
        refix_params = _self.env['ir.config_parameter'].sudo().get_param("refix_auto_work_order")
        return {"code": 0, "message": "成功！", "state": refix_params == "True" or refix_params is True}
