import logging
import os
from jinja2 import FileSystemLoader, Environment
import pytz
from odoo import models, fields, api, http, SUPERUSER_ID, _
from odoo.addons.roke_workstation_api.controllers.data_analysis import reduce_pytz_conversion, pytz_conversion
from odoo.addons.roke_workstation_api.controllers.work_order import RokeWorkstationWorkOrder
from odoo.addons.roke_mes_entrust_order.controller.main import Main

_logger = logging.getLogger(__name__)


# 设置查找html文件的路径
BASE_DIR = os.path.dirname(os.path.dirname(__file__))
templateloader = FileSystemLoader(searchpath=BASE_DIR + "/static")
env = Environment(loader=templateloader)


class RokeWorkstationTaskModel(http.Controller):

    @http.route('/roke/main_task/index', type='http', auth='user', csrf=False, cors="*")
    def roke_main_task_index(self, **kwargs):
        user_id = http.request.env.user.id
        values = {
            "user_id": user_id
        }
        template = env.get_template('/src/html/view/main_task.html')
        html = template.render(values)
        return html

    @staticmethod
    def _get_product_image_avatar_url(_id):
        attachment = http.request.env['ir.attachment'].sudo().search([
            ("res_model", "=", "roke.product"), ("res_id", "=", _id),
            ("res_field", "=", "image_1920")
        ])
        if not attachment.access_token:
            attachment.generate_access_token()
        return f"/web/image/{attachment.id}?access_token={attachment.access_token}&unique=" \
               f"{str(fields.Datetime.now().timestamp())}"

    @http.route('/roke/workstation/get_main_task_data', type='json', methods=['POST', 'OPTIONS'], auth="none",
                csrf=False, cors='*')
    def get_main_task_data(self):
        _self = http.request
        limit = _self.jsonrequest.get("limit", 20)
        page = _self.jsonrequest.get("page", 1)
        state = _self.jsonrequest.get("state", False)
        priority = _self.jsonrequest.get("priority", False)
        task_code = _self.jsonrequest.get("task_code", False)
        domain = ["|", ("task_type", "=", "main"), ("task_type", "=", False)]
        if task_code:
            domain = [("code", "ilike", task_code)]
        if state:
            domain.append(("state", "=", state))
        if priority:
            domain.append(("priority", "=", priority))
        task_ids = _self.env["roke.production.task"].sudo().search(domain, limit=limit, offset=(page - 1) * limit,
                                                                   order="code desc")
        task_counts = _self.env["roke.production.task"].sudo().search_count(domain)
        task_list = []
        complete_basis = _self.env.user.company_id.complete_basis

        def get_work_order(_task, _complete_basis):
            work_list = []
            for work in _task.work_order_ids:
                if hasattr(work, "is_entrust") and work.is_entrust:
                    work_state = "未开工" if work.entrust_state == "未发料" else \
                        ("进行中" if work.state == "未完工" else ("已完工" if work.state != "暂停" else "暂停"))
                else:
                    work_state = work.wo_start_state if work.wo_start_state == "未开工" else \
                        ("进行中" if work.state == "未完工" else ("已完工" if work.state != "暂停" else "暂停"))
                work_data = {
                    "id": work.id,
                    "code": work.code,
                    "process_id": work.process_id.id,
                    "state": work_state,
                    "process_name": work.process_id.name,
                    "progress": 0 if work.plan_qty == 0 else
                    round(((work.finish_qty if _complete_basis in ["合格数", "手动完工"] else
                            (work.finish_qty + work.unqualified_qty)) / work.plan_qty) * 100, 2)
                }
                work_list.append(work_data)
            return {
                "code": _task.code or "",
                "product_id": _task.product_id.id or 0,
                "product_name": _task.product_id.name or "",
                "product_image_url": self._get_product_image_avatar_url(_task.product_id.id),
                "state": _task.state or "",
                "priority": _task.priority or "",
                "unqualified_qty": sum(_task.work_order_ids.mapped("unqualified_qty")) or 0,
                "work_order": work_list
            }

        if task_code:
            for v in task_ids:
                data = get_work_order(v, complete_basis)
                task_list.append(data)
            return {"code": 0, "message": "获取成功", "data": task_list, "count": task_counts}
        for v in task_ids:
            data = get_work_order(v, complete_basis)
            task_str = ""
            if "-" in v.code:
                task_str = v.code.split('-')[0]
            sub_task = _self.env["roke.production.task"].sudo().search([("task_type", "=", "sub"),
                                                                        ("main_task_code", "=", task_str)],
                                                                       order="code asc")
            data["children"] = [get_work_order(child, complete_basis) for child in sub_task]
            task_list.append(data)
        return {"code": 0, "message": "获取成功", "data": task_list, "count": task_counts}
