from odoo import models, fields, api, _


class InheritRokeRoutingLine(models.Model):
    _inherit = "roke.routing.line"

    rated_working_hours = fields.Float(string='标准工时', help='工序的标准工时(小时)')
    special_process = fields.Selection([('是', '是'), ('否', '否')], string="特殊工序", default='否')


class InheritRokeRouting(models.Model):
    _inherit = "roke.routing"

    def get_routing_line_value(self, line):
        """
                获取工艺明细内容
                :param process:
                :return:
                """
        res = super(InheritRokeRouting, self).get_routing_line_value(line)
        res.update({
            "special_process": line.special_process
        })
        return res


class InheritRokeProcess(models.Model):
    _inherit = "roke.process"

    rated_working_hours = fields.Float(string='标准工时', help='工序的标准工时(小时)')
