import datetime
import json
import logging
import os
from jinja2 import FileSystemLoader, Environment
import pytz
from odoo import models, fields, api, http, SUPERUSER_ID, _
from odoo.addons.roke_workstation_api.controllers.data_analysis import reduce_pytz_conversion, pytz_conversion

_logger = logging.getLogger(__name__)


# 设置查找html文件的路径
BASE_DIR = os.path.dirname(os.path.dirname(__file__))
templateloader = FileSystemLoader(searchpath=BASE_DIR + "/static")
env = Environment(loader=templateloader)


class RokeWorkstationWorkOrderModel(http.Controller):

    @http.route('/roke/craft_design/index', type='http', auth='user', csrf=False, cors="*")
    def roke_index_demo_module(self, **kwargs):
        product_id = kwargs.get("product_id", False)
        routing_id = kwargs.get("routing_id", False)
        user_id = http.request.env.user.id
        values = {
            "product_id": product_id,
            "routing_id": routing_id,
            "user_id": user_id
        }
        template = env.get_template('/src/html/index.html')
        html = template.render(values)
        return html

    @http.route('/roke/workstation/craft_design/workstation_product/get', type='json', auth='user', csrf=False, cors="*")
    def workstation_product_get(self):
        """
        获取工单的不良报工记录
        """
        _self = http.request
        product_id = _self.jsonrequest.get("product_id", 0)
        product = _self.env["roke.product"].sudo().search([("id", "=", product_id)])
        data = {
            "type": "product",
            "parent_id": 0,
            "id": product.id,
            "name": product.name or "",
            "specification": product.specification or "",
            "code": product.code or "",
            "capacity": product.capacity or 0.0,
            "fpy": product.fpy or 0.0,
            "category": {"id": product.category_id.id, "name": product.category_id.name or ""},
            "has_bom": False,
        }
        return {"code": 0, "message": f"获取成功！", "data": data}

    @http.route('/roke/workstation/work_record/workstation_work_record', type='json', auth='user', csrf=False, cors="*")
    def get_workstation_work_record(self):
        """
        获取工单的不良报工记录
        """
        _self = http.request
        work_order_id = _self.jsonrequest.get("work_order_id", 0)
        limit = _self.jsonrequest.get("limit", 20)
        page = _self.jsonrequest.get("page", 1)
        if not work_order_id:
            return {"code": 1, "message": f"入参错误！ “工单ID”为必传数据。", "data": []}
        record_ids = _self.env["roke.work.record"].search([
            ("unqualified_qty", "!=", 0),
            ("work_order_id", "=", work_order_id)
        ], order="create_date desc", limit=limit, offset=(page - 1) * limit)
        data = []
        for v in record_ids:
            scrap_name_list = v.scrap_line_ids.reason_id.mapped("name")
            data.append({
                "id": v.id,
                "scrap_name": (scrap_name_list and scrap_name_list[0]) or "",
                "unqualified_qty": v.unqualified_qty or 0,
                "scrap_qty": sum(v.scrap_line_ids.mapped("qty")),
                "repair_qty": sum(v.repair_line_ids.mapped("qty")),
                "is_rfe": v.scrap_line_ids.order_id.is_rfe,
                "work_time": pytz_conversion(_self, v.work_time.strftime('%Y-%m-%d %H:%M'))
            })
        return {"code": 0, "message": f"获取成功！", "data": data}

    @http.route('/roke/workstation/work_record/get_workstation_work_process', type='json', auth='user', csrf=False, cors="*")
    def get_workstation_work_process(self):
        """
        获取工单的任务内的工序
        """
        _self = http.request
        work_order_id = _self.jsonrequest.get("work_order_id", 0)
        if not work_order_id:
            return {"code": 1, "message": f"入参错误！ “工单ID”为必传数据。", "data": []}
        work_order = _self.env["roke.work.order"].search([("id", "=", work_order_id)])
        if not work_order_id:
            return {"code": 1, "message": f"校验错误！ 没找到对应的工单。", "data": []}
        data = []
        work_order_ids = work_order.task_id.work_order_ids or work_order.repair_task_id.work_order_ids
        for v in work_order_ids:
            data.append({
                "id": v.process_id.id or 0,
                "name": v.process_id.name or ""
            })
        return {"code": 0, "message": f"获取成功！", "data": data}

    @http.route('/roke/workstation/scrap_order/get_workstation_work_process', type='json', auth='user', csrf=False,
                cors="*")
    def scrap_order_get_workstation_work_process(self):
        """
        生成补件工单
        """
        _self = http.request
        work_record_id = _self.jsonrequest.get("work_record_id", 0)
        process_list = _self.jsonrequest.get("process_list", [])
        if not work_record_id:
            return {"code": 1, "message": f"入参错误！ “报工记录ID”为必传数据。"}
        if not process_list:
            return {"code": 1, "message": f"入参错误！ “工序”为必传数据。"}
        work_record = _self.env["roke.work.record"].search([("id", "=", work_record_id)])
        if not work_record_id:
            return {"code": 1, "message": f"校验错误！ 没找到对应的报工记录。"}
        work_order_ids = []
        index = 1
        # qty = 0
        for v in process_list:
            plan_qty = v.get("qty", 0)
            # qty = plan_qty if qty == 0 or qty > plan_qty else qty
            process_id = v.get("id", 0)
            work_order_ids.append((0, 0, {
                    "process_id": process_id,
                    "product_id": work_record.work_order_id.product_id.id,
                    "plan_qty": plan_qty,
                    "sequence": index,
                    "planned_start_time": work_record.work_order_id.planned_start_time,
                    "plan_date": work_record.work_order_id.plan_date,
                    "repair_task_id": work_record.pt_id.id or work_record.work_order_id.repair_task_id.id,
                    "type": "补件"
                }))
            index += 1
        for v in work_record.scrap_line_ids:
            v.write({
                "scrap_work_order_ids": work_order_ids,
                # "replenish_qty": v.replenish_qty + qty,  #  零部件问题： 导致已补数量没法计算
                "is_rfe": True
            })
            break
        work_record.scrap_line_ids.order_id.write({"is_rfe": True})
        return {"code": 0, "message": f"补件工单创建成功！"}
