import logging
import pytz
from odoo import models, fields, api, http, SUPERUSER_ID, _
from odoo.addons.roke_workstation_api.controllers.product_task import RokeWorkstationProductionTask
from odoo.addons.roke_workstation_api.controllers.work_order import RokeWorkstationWorkOrder
_logger = logging.getLogger(__name__)


class InheritRokeWorkstationProductionTask(RokeWorkstationProductionTask):
    @http.route('/roke/workstation/product_task/machine_get_list', type='json', auth='user', csrf=False, cors="*")
    def product_task_machine_get_list(self):
        """
        获取当前用户权限下所有任务的数据
        workstation_id: int 工位ID
        limit: int 条数
        page: int 页数
        """
        _self = http.request
        workstation_id = _self.jsonrequest.get("workstation_id", False)
        priority = _self.jsonrequest.get("priority", False)
        customer_id = _self.jsonrequest.get("customer_id", False)
        limit = _self.jsonrequest.get("limit", 20)
        page = _self.jsonrequest.get("page", 1)
        search_code = _self.jsonrequest.get("search_code", False)

        if not workstation_id:
            return {"code": 1, "message": f"入参错误！ “工位ID”为必传数据。", "data": []}
        workstation = _self.env["roke.work.center"].search(
            [("id", "=", workstation_id)])
        if not workstation:
            return {"code": 1, "message": "校验错误！ 未找到该工位数据。", "data": []}
        user_id = _self.env['roke.employee'].search(
            [('user_id', '=', http.request.uid)], limit=1)
        process_ids = _self.env['roke.process'].search(
            [('workstation_ids', '=', workstation_id)])
        # process_list = list(set(process_ids.ids) & set(user_id.process_ids.ids))
        process_list = process_ids.ids
        if not process_ids:
            return {"code": 0, "message": "获取成功！", "data": [], "process_ids": [], "count": 0}
        domain = [
            "|",
            ("work_center_id", "=", workstation.workshop_id.id),
            "&",
            ("work_center_id", "=", False),
            ("task_id.workshop_id", "=", workstation.workshop_id.id),
            ("process_id", "in", process_list),
            ("state", "in", ["未完工", "暂停"])
        ]
        if priority:
            domain.append(('task_id.priority', '=', priority))
        if customer_id:
            domain.append(('task_id.customer_id', '=', customer_id))
        if search_code:
            domain.append("|")
            domain.append("|")
            domain.append("|")
            domain.append("|")
            domain.append("|")
            domain.append("|")
            domain.append(("task_id.code", "ilike", search_code))
            domain.append(('task_id.customer_id.name', 'ilike', search_code))
            domain.append(("code", "ilike", search_code))
            domain.append(("task_id.product_id.name", "ilike", search_code))
            domain.append(("task_id.lot_code", "ilike", search_code))
            domain.append(("process_id.name", "ilike", search_code))
            domain.append(("task_id.product_id.specification", "ilike", search_code))
        work_order = _self.env["roke.work.order"].search(domain)
        sql = f"""
            SELECT id, type, create_date
            FROM (
                {f'''SELECT roke_production_task.id, 'task' as "type", roke_production_task.create_date
                FROM roke_production_task LEFT JOIN roke_work_order on roke_work_order.task_id = roke_production_task.id
                WHERE roke_work_order.id in ({" , ".join([f"{v}" for v in work_order.ids])})
                and roke_production_task.state in ('未完工', '暂停')
                group by roke_production_task.id
                union all''' if work_order.ids else ""}
                SELECT id, 'work' as "type", create_date
                FROM roke_work_order
                WHERE type in ('返修', '补件')
                and process_id in ({" , ".join([f"{v}" for v in process_list])})
                and state = '未完工'
                and repair_task_id is not null {f''' and code ilike '%{search_code}%' ''' if search_code else ""}
                group by id
            ) as task_repair_work
            ORDER BY create_date desc
            LIMIT {limit}
            offset {(page - 1) * limit}
        """
        _self.env.cr.execute(sql)
        results = _self.env.cr.dictfetchall()
        count_sql = f"""
            SELECT count(id)
            FROM (
                {f'''SELECT roke_production_task.id
                FROM roke_production_task LEFT JOIN roke_work_order on roke_work_order.task_id = roke_production_task.id
                WHERE roke_work_order.id in ({" , ".join([f"{v}" for v in work_order.ids])})
                and roke_production_task.state in ('未完工', '暂停')
                group by roke_production_task.id
                union all''' if work_order.ids else ""}
                SELECT id
                FROM roke_work_order
                WHERE type in ('返修', '补件')
                and process_id in ({" , ".join([f"{v}" for v in process_list])})
                and state = '未完工'
                and repair_task_id is not null {f''' and code ilike '%{search_code}%' ''' if search_code else ""}
                group by id
            ) as task_repair_work
        """
        _self.env.cr.execute(count_sql)
        task_count = _self.env.cr.dictfetchall()[0].get("count", 0)
        ids_list = []
        task_id_list = []
        work_id_list = []
        for v in results:
            data_type = v.get("type", '')
            data_id = v.get("id", 0)
            # 排序后的列表数据，【ID，该条数据类型】（为了作分页）
            ids_list.append([data_id, data_type])
            if data_type == 'task':
                task_id_list.append(data_id)
            if data_type == 'work':
                work_id_list.append(data_id)
        task_ids = _self.env["roke.production.task"].search(
            [("id", "in", task_id_list)])
        work_ids = _self.env["roke.work.order"].search(
            [("id", "in", work_id_list)])
        task_data_dict = {}
        for v in task_ids:
            current_process = ''
            current_process_num = len(v.work_order_ids)
            for record in v.work_order_ids:
                if record.wo_start_state == '未开工' or record.state in ('未完工', '暂停'):
                    current_process = record.process_id.name
                    current_process_num -= 1
                    break
                else:
                    current_process_num -= 1
                    continue
            task_data_dict[str(v.id)] = {
                "id": v.id,
                "code": v.code,
                "state": v.state,
                "partner": {"id": v.customer_id.id or None, "name": v.customer_id.name or ""},
                "plan_qty": v.plan_qty or 0,
                "product": {"id": v.product_id.id or None, "name": v.product_id.name or ""},
                "priority": v.priority,
                "planned_start_time": v.plan_start_date.strftime('%Y-%m-%d') if v.plan_start_date else "",
                "plan_date": v.plan_date.strftime('%Y-%m-%d') if v.plan_date else "",
                "specification": v.product_id.specification or "",
                "model": v.product_id.model or "",
                "order_type": "task",
                "type": "",
                "current_process": current_process,
                "current_process_num": current_process_num
            }
        work_data_dict = {}
        for v in work_ids:
            work_data_dict[str(v.id)] = {
                "id": v.id,
                "code": v.code,
                "state": v.state,
                "partner": {"id": v.repair_task_id.customer_id.id or None,
                            "name": v.repair_task_id.customer_id.name or ""},
                "plan_qty": v.plan_qty or 0,
                "product": {"id": v.product_id.id or None, "name": v.product_id.name or ""},
                "priority": v.priority,
                "planned_start_time": v.planned_start_time.strftime('%Y-%m-%d') if v.planned_start_time else "",
                "plan_date": v.plan_date.strftime('%Y-%m-%d') if v.plan_date else "",
                "specification": v.product_id.specification or "",
                "model": v.product_id.model or "",
                "order_type": "work",
                "type": v.type,
                "current_process": v.process_id.name,
                "current_process_num": len(v.task_id.work_order_ids.filtered(lambda wo: wo.sequence > v.sequence))
            }
        data = []
        for v in ids_list:
            l_id = v[0]
            l_type = v[1]
            if l_type == "task":
                task_data = task_data_dict.get(str(l_id), False)
                if not task_data:
                    continue
                data.append(task_data)
            if l_type == "work":
                work_data = work_data_dict.get(str(l_id), False)
                if not work_data:
                    continue
                data.append(work_data)
        return {"code": 0, "message": "获取成功！", "data": data, "process_ids": process_list, "count": task_count}


class InheritRokeWorkstationWorkOrder(RokeWorkstationWorkOrder):

    @http.route('/roke/workstation/work_order/workstation_work_order', type='json', auth='user', csrf=False, cors="*")
    def workstation_work_order(self):
        """
        获取当前任务下对应工序的未完成的第一位列的工单的数据
        workstation_id: int 工位ID
        limit: int 条数
        page: int 页数
        """
        _self = http.request
        task_id = _self.jsonrequest.get("task_id", False)
        work_order_id = _self.jsonrequest.get("work_order_id", False)
        work_center_id = _self.jsonrequest.get("work_center_id", False)
        process_ids = _self.jsonrequest.get("process_ids", [])

        if not task_id:
            return {"code": 1, "message": f"入参错误！ “任务ID”为必传数据。", "data": {}}
        if not process_ids:
            return {"code": 1, "message": f"入参错误！ “工序列表”为必传数据。", "data": {}}
        if not work_center_id:
            return {"code": 1, "message": f"入参错误！ “工位ID”为必传数据。", "data": {}}

        domain = [
            "|", "&", "&", "&",
            ("task_id", "=", task_id),
            ("process_id", "in", process_ids),
            ("state", "in", ["未完工", "暂停"]),
            ("work_center_id", "=", False),
            ("work_center_id", "=", work_center_id)
        ]
        if work_order_id:
            domain = [("id", "=", work_order_id)]
        work_order = _self.env["roke.work.order"].search(domain, order=f"sequence asc, process_id asc, id asc", limit=1)
        if not work_order:
            return {"code": 1, "message": "数据获取失败！", "data": {}}

        allow_qty, _ = work_order._get_wo_allow_qty()
        user_tz = pytz.timezone(_self.env.context.get('tz', "Asia/Shanghai"))

        operation_after_completion = _self.env(user=SUPERUSER_ID)['ir.config_parameter'].get_param(
            'operation.after.completion', default="无操作"
        )
        print_code = False
        if operation_after_completion == "打印批次条码":
            print_code = True

        data = {
            "id": work_order.id,
            "task_id": work_order.task_id.id,
            "code": work_order.code,
            "type": work_order.type or "",
            "state": work_order.state,
            "allow_qty": allow_qty,
            "wo_start_state": work_order.wo_start_state,
            "process_id": work_order.process_id.id,
            "process": {"id": work_order.process_id.id or 0, "name": work_order.process_id.name or ""},
            "partner": {"id": work_order.customer_id.id or None, "name": work_order.customer_id.name or ""},
            "plan_qty": work_order.plan_qty or 0,
            "product": {"id": work_order.product_id.id or None, "name": work_order.product_id.name or ""},
            "priority": work_order.priority,
            "finish_qty": work_order.finish_qty,
            "unqualified_qty": work_order.unqualified_qty,
            "routing_id": work_order.task_id.routing_id.id or work_order.product_id.routing_id.id,
            "routing_line_id": work_order.routing_line_id.id or 0,
            "planned_start_time": pytz.utc.localize(work_order.planned_start_time).astimezone(user_tz)
            .strftime('%Y-%m-%d %H:%M:%S') if work_order.planned_start_time else "",
            "plan_date": pytz.utc.localize(work_order.plan_date).astimezone(user_tz)
            .strftime('%Y-%m-%d %H:%M:%S') if work_order.plan_date else "",
            # UI 判断信息
            "track_type": work_order.task_id.track_type,
            "enable_traceability": work_order.product_id.enable_traceability,
            "traceability_strategy": work_order.product_id.traceability_strategy,
            "is_passing_report": work_order.workshop_id.is_passing_report,
            "print_code": print_code,
            # 补充信息
            "specification": work_order.product_id.specification or "",
            "complete_basis": http.request.env.company.complete_basis or "",
            # 物料批次码
            "lot_code_id": work_order.task_id.code_ids[0].id if work_order.task_id.code_ids else False,
        }
        if work_order.product_id.traceability_strategy == "物料防错":
            data["material_demands"] = [
                {
                    "id": line.material_id.id,
                    "name": line.material_id.name,
                    "code": line.material_id.code,
                    "demand_qty": line.demand_qty,
                    "finished_qty": line.finished_qty,
                    "protection_code": line.protection_code or "",
                }
                for line in work_order.material_demand_ids
            ]
        if not work_order_id or not work_order:
            return {"code": 0, "message": "获取成功！", "data": data}
        if work_order.type == "返修":
            repair_order_line = _self.env["roke.repair.order.line"].search([
                ("repair_work_order_id", "=", work_order.id)
            ], limit=1)
            if repair_order_line:
                repair_work_order = work_order.repair_wr_id.work_order_id
                data.update({
                    "routing_id": repair_work_order.task_id.routing_id.id,
                    "routing_line_id": repair_work_order.routing_line_id.id,
                    "partner": {"id": repair_work_order.task_id.customer_id.id or None,
                                "name": repair_work_order.task_id.customer_id.name or ""},
                    "lot_code_id": repair_work_order.task_id.code_ids[0].id if repair_work_order.task_id.code_ids
                    else False
                })
        elif work_order.type == "补件":
            scrap_order_line = _self.env["roke.scrap.order.line"].search([("scrap_work_order_ids", "=", work_order.id)],
                                                                         limit=1)
            if scrap_order_line:
                task_id = scrap_order_line.order_id.wr_id.work_order_id.task_id or \
                          scrap_order_line.order_id.wr_id.work_order_id.repair_task_id
                routing_id = task_id.routing_id
                line_id = 0
                for v in routing_id.line_ids:
                    if work_order.process_id.id != v.process_id.id:
                        continue
                    line_id = v.id
                    break
                data.update({
                    "routing_id": routing_id.id,
                    "routing_line_id": line_id,
                    "partner": {"id": task_id.customer_id.id or None, "name": task_id.customer_id.name or ""},
                    "lot_code_id": task_id.code_ids[0].id if task_id.code_ids else False
                })
        return {"code": 0, "message": "获取成功！", "data": data}
