import requests
from odoo import models, fields, api, _
from odoo.exceptions import UserError
import psycopg2, pymssql, cx_Oracle
import json
import logging
import datetime

_logger = logging.getLogger(__name__)


class RokePubIntegrateModel(models.Model):

    _inherit = "roke.pub.integrate.model"

    time_type = fields.Selection(selection_add=[("YMD", "YMD")], string="时间类型")

    def sync_pull_database(self, **kwargs):
        _logger.info("----------------------******数据库直连下拉数据******----------------------")
        sync_address = self.system_id.sync_address
        sync_port = self.system_id.sync_port
        sync_uname = self.system_id.sync_uname
        sync_passwd = self.system_id.sync_passwd
        db_name = self.system_id.db_name
        if self.db_type == 'PostgreSQL':
            conn = psycopg2.connect(host=sync_address, port=int(sync_port), user=sync_uname, password=sync_passwd,
                                    database=db_name)
            cur = conn.cursor()
        elif self.db_type == 'Microsoft SQL Server':
            # conn = pymssql.connect(host="%s:%s" % (sync_address, sync_port), user=sync_uname, password=sync_passwd, database=db_name)
            conn = pymssql.connect(host=sync_address, user=sync_uname, password=sync_passwd, database=db_name)
            cur = conn.cursor()
        elif self.db_type == 'oracle':
            conn = cx_Oracle.connect(sync_uname, sync_passwd, '%s:%s/ORCL' % (sync_address, sync_port))
            cur = conn.cursor()
        else:
            raise UserError('非预制类型')
        wheresql = ""
        # 时间轴字段where条件拼接
        if self.sync_mode == "时间轴" and self.time_axis_field and self.last_execute_time:
            if self.time_type == "Y-M-D H:M:S":
                wheresql += " and %s >= '%s'" % (self.time_axis_field, self.last_execute_time.strftime("%Y-%m-%d %H:%M:%S"))
            elif self.time_type == "YMD HMS":
                wheresql += " and %s >= '%s'" % (self.time_axis_field, self.last_execute_time.strftime("%Y%m%d %H%M%S"))
            else:
                wheresql += " and %s >= %s" % (self.time_axis_field, self.last_execute_time.strftime("%Y%m%d"))
        # 填写的where条件拼接
        if self.where_sql:
            wheresql += self.where_sql
        # 入参where条件拼接
        for integrate_input in self.integrate_input_ids:
            if integrate_input.is_required and not integrate_input.fixed:
                if not kwargs.get(integrate_input.enter_name):
                    raise UserError("入参[%s]必填!" % integrate_input.enter_name)
                wheresql += " and %s='%s'" % (integrate_input.enter_name, kwargs.get(integrate_input.enter_name))
            else:
                if integrate_input.fixed:
                    wheresql += " and %s='%s'" % (integrate_input.enter_name, integrate_input.enter_data)
        # 拼接查询字段
        select_field = ""
        for integrate_field in self.integrate_field_ids:
            if not integrate_field.fixed:
                select_field += "%s, " % integrate_field.opposite_field_name
        select_field = select_field[:-2]
        cur.execute("select {} from {} where 1=1 {}".format(select_field, self.opposite_model, wheresql))
        rows = cur.fetchall()
        rowdesc = cur.description
        data_dicts = [
            dict(zip([col[0] for col in rowdesc], row))
            for row in rows
        ]
        cur.close()
        conn.close()
        self.sync_analysis_database(data_dicts)
        if self.logging_enable:
            self.env["roke.pub.integrate.log"].create({
                "requst_parameter": wheresql,
                "response_result": str(data_dicts),
                "integrate_model_id": self.id,
            })

    def sync_analysis_database(self, rel_data):
        print("------------------------****数据库直连方式解析数据%s****------------------------" % rel_data)
        parent_model_ = self.env[self.parent_model_name]
        parent_model_fields = []  # 主表字段对象
        for integrate_field in self.integrate_field_ids:
            if integrate_field.grade_sign == "主表":
                parent_model_fields.append(integrate_field)
        # 按检索字段查询数据是否存在
        parent_retrieval_field_obj = [parent_model_field for parent_model_field in parent_model_fields if
                                      parent_model_field.retrieval_field_name == True]
        # parent_retrieval_field_obj = parent_retrieval_field_obj[0] if parent_retrieval_field_obj else None
        for data in rel_data:
            model_obj = None
            if parent_retrieval_field_obj:
                domain = []
                for parent_retrieval_field in parent_retrieval_field_obj:
                    if parent_retrieval_field.fixed:  # 判断是否固定值
                        field_value = parent_retrieval_field.fixed_value
                        # 判断字段类型
                        FieldsObj = self.env["ir.model.fields"].search([
                            ("model_id.model", "=", self.parent_model_name),
                            ("name", "=", parent_retrieval_field.field_name)
                        ])
                        if FieldsObj.ttype == "many2one":
                            # field_value = int(field_value)
                            try_convert_to_int = lambda value: int(value) if str(value).isdigit() else None
                            field_value = try_convert_to_int(field_value)
                    else:
                        field_value = data.get(parent_retrieval_field.opposite_field_name)
                    domain.append(
                        (parent_retrieval_field.field_name, '=', field_value)
                    )
                model_obj = parent_model_.search(domain)

            # if parent_retrieval_field_obj:
            #     model_obj = parent_model_.search([(parent_retrieval_field_obj.field_name, '=',
            #                                        data.get(parent_retrieval_field_obj.opposite_field_name))])
            model_data = {}
            for integrate_field in self.integrate_field_ids:
                if integrate_field.fixed:  # 判断是否固定值
                    field_value = integrate_field.fixed_value
                else:
                    field_value = data.get(integrate_field.opposite_field_name)
                    if integrate_field.relation:  # 判断是否是关联字段
                        field_value = self.env[integrate_field.relation_model_name].search(
                            [(integrate_field.relation_field_name, '=', field_value)]).id
                    if integrate_field.switch:  # 判断是否需要取值转换
                        for condition in integrate_field.condition_ids:
                            # 通过配置的运算符进行运算 代替↑if代码
                            global_param = {
                                "field_value": field_value,
                                "check_value": condition.check_value
                            }
                            formula_str = f"""
global field_value, check_value
flag = True if field_value %s check_value else False
""" % (condition.option)
                            _logger.info(formula_str)
                            param = {}
                            exec(formula_str, global_param, param)
                            flag = param["flag"]
                            if flag:
                                field_value = condition.rel_value
                                field_value = self.data_convert(field_value)
                                _logger.info(condition.rel_value)
                model_data[integrate_field.field_name] = field_value
            _logger.info(model_data)
            if self.parent_model_id.model == "roke.production.task" and model_obj:
                continue
            if model_obj:
                data = model_obj.write(model_data)
            else:
                data = parent_model_.create(model_data)
            if self.parent_model_id.model == "roke.production.task" and data.product_id:
                data.routing_id = data.product_id.routing_id
                data.create_work_order()
